// Kinetophone_dbus_server.hpp
//
// Copyright 2011 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_DBUS_SERVER_HPP_
#define KINETOPHONE_DBUS_SERVER_HPP_

#include <dbus-c++/dbus.h>
#include "../base/common.hpp"
#include "Kinetophone_dbus_server_glue.hpp"
#include <string>
#include <vector>
#include <map>

using DBus::Connection;
using DBus::IntrospectableAdaptor;
using DBus::ObjectAdaptor;
using std::string;
using std::vector;
using std::map;

namespace Roan_trail
{
  typedef map<string, string> Error_dictionary;

  namespace Kinetophone {
    class Kinetophone_dbus_recorder;

    class Kinetophone_dbus_server
      : public com::roantrail::dbus::kinetophone_adaptor,
        public IntrospectableAdaptor,
        public ObjectAdaptor
    {
    public:
      Kinetophone_dbus_server(Connection& connection);
      // DBUS interface
      //   control
      void create_recorder(string& return_recorder_path,
                           bool& return_have_error,
                           Error_dictionary& return_error);
      void remove_recorder(const string& recorder_path,
                           bool& return_have_error,
                           Error_dictionary& return_error);
      void list_recorders(vector<string>& return_recorder_paths,
                           bool& return_have_error,
                           Error_dictionary& return_error);
    protected:
      bool mf_invariant(bool check_base_class = true) const;
    private:
      // data members
      map<string, Kinetophone_dbus_recorder*> m_recorders;
      Long_int m_recorder_ID;
      // prevent compiler from generating
      Kinetophone_dbus_server(const Kinetophone_dbus_server& server);
      Kinetophone_dbus_server& operator=(const Kinetophone_dbus_server& server);
    };
  }
}

#endif // KINETOPHONE_DBUS_SERVER_HPP_
