// Kinetophone_builder_model.hpp
//
// Copyright 2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_BUILDER_MODEL_HPP_
#define KINETOPHONE_BUILDER_MODEL_HPP_

#include "../base/Movie_builder_model.hpp"

#include <string>
#include <vector>

namespace Gdk
{
  class Pixbuf;
}

namespace Glib
{
  template <class T> class RefPtr;
}

using std::string;
using std::vector;
using Gdk::Pixbuf;
using Glib::RefPtr;

namespace Roan_trail
{
  class Error_param;

  namespace Source
  {
    template <class Image> class Slide_collection;
  }

  using Source::Slide_collection;
  using Builder::Movie_builder_model;

  namespace Kinetophone
  {
    class Kinetophone_slide_collection;

    class Kinetophone_builder_model : public Movie_builder_model
    {
    public:
      // constructor/destructor
      Kinetophone_builder_model(const string& slides_source_type);
      ~Kinetophone_builder_model();
      // accessors
      const Slide_collection<RefPtr<Pixbuf> >* slides() const { return m_slides; }
      // load
      bool load_from_XML(const string& file_path, Error_param& return_error);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      Slide_collection<RefPtr<Pixbuf> >* m_slides;
      string m_slides_source_type;
      // prevent compiler from generating
      Kinetophone_builder_model(const Kinetophone_builder_model& builder_model);
      Kinetophone_builder_model& operator=(const Kinetophone_builder_model& builder_model);
    };
  }
}

#endif // KINETOPHONE_BUILDER_MODEL_HPP_
