// Kinetophone_builder_config.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_BUILDER_CONFIG_HPP_
#define KINETOPHONE_BUILDER_CONFIG_HPP_

#include <string>
#include <vector>

using std::string;
using std::vector;

namespace Roan_trail
{
  class Error_param;

  namespace Builder
  {
    struct Movie_builder_config;
  }

  using Roan_trail::Builder::Movie_builder_config;

  namespace Kinetophone
  {
    // Helper struct to store builder application settings.
    // It is a struct instead of a class since it primarily only
    // aggregates various data
    struct Kinetophone_builder_config
    {
    public:
      // constructor/destructor/copy
      Kinetophone_builder_config();
      Kinetophone_builder_config(const Kinetophone_builder_config& config);
      Kinetophone_builder_config& operator=(const Kinetophone_builder_config& config);
      virtual ~Kinetophone_builder_config();
      // structure members
      string help_message;
      string session_file_path;
      string image_directory;
      Movie_builder_config* movie_builder_config;
      bool detailed_error;
      bool quit_on_prebuild_warnings;
      string custom_installation_dir;
      // command class constants
      static const int command_error          = 0;
      static const int command_build          = 1;
      static const int command_help           = 2;
      static const int command_output_version = 3;
      //
      int parse_program_options(int argc,
                                const char** argv,
                                Error_param& return_error);
    };
  }
}

#endif // KINETOPHONE_BUILDER_CONFIG_HPP_
