// Image_types.hpp
//
// Copyright 2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef IMAGE_TYPES_HPP_
#define IMAGE_TYPES_HPP_

#include "common.hpp"

namespace Roan_trail
{
  struct Rect_size
  {
    Rect_size() : width(0), height(0) {}
    Rect_size(int w, int h) : width(w), height(h) {}
    bool operator==(const Rect_size& s) const { return ((width == s.width) && (height == s.height)); }
    bool operator!=(const Rect_size& s) const { return !operator==(s); }
    Rect_size operator*(double m) const { return Rect_size(width * m, height * m); }
    int width;
    int height;
  };
  struct Rect_origin
  {
    Rect_origin() : x(0), y(0) {}
    Rect_origin(int x_i, int y_i) : x(x_i), y(y_i) {}
    bool operator==(const Rect_origin& o) const { return ((x == o.x) && (y == o.y)); }
    bool operator!=(const Rect_origin& o) const { return !operator==(o); }
    int x;
    int y;
  };
  struct Rectangle
  {
    Rectangle(Rect_origin o, Rect_size s) : origin(o), size(s) {}
    bool operator==(const Rectangle& r) const { return ((origin == r.origin) && (size == r.size)); }
    bool operator!=(const Rectangle& r) const { return !operator==(r); }
    Rect_origin origin;
    Rect_size size;
  };
  struct Color
  {
    Color(uint32_t scalar, bool has_a = false)
      : red((scalar >> 24) & 0xFF),
        green((scalar >> 16) & 0xFF),
        blue((scalar >> 8) & 0xFF),
        alpha(scalar & 0xFF),
        has_alpha(has_a) {}
    Color(uint8_t r = 0,
          uint8_t g = 0,
          uint8_t b = 0,
          uint8_t a = 0,
          bool has_a = false)
      : red(r),
        green(g),
        blue(b),
        alpha(a),
        has_alpha(has_a) {}
    // convert to RRGGBBAA (0xFFFFFFFF white to 0x00000000 black)
    int32_t scalar_value() const
    { return (static_cast<int32_t>(red) << 24)
        | (static_cast<int32_t>(green) << 16)
        | (static_cast<int32_t>(blue) << 8)
        | (static_cast<int32_t>(alpha)); }
    //
    uint8_t red;
    uint8_t green;
    uint8_t blue;
    uint8_t alpha;
    bool has_alpha;
  };
}

#endif // IMAGE_TYPES_HPP_
