%define name	kickproc
%define version	1.0
%define release	3


Summary: 	performs actions on processes matched conditions
Name: 		%{name}
Version: 	%{version}
Release: 	%{release}
Group: 		Utilities/System
License:        GPL
Source: 	http://www.inp.nsk.su/~fedorov/export/%{name}-%{version}.tar.gz
#Url: 		http://www.cpan.org/
#Distribution:	MustDie/2000
#Vendor:	DF-Soft
Packager:       Dmitry Fedorov <fedorov@cpan.org>

#Provides:	"virtual package"
Requires: 	perl >= 5.5.0, perl-Proc-ProcessTable >= 0.39
#Conflicts:	%{name} < %{version}

BuildRoot: 	%{_tmppath}/%{name}-buildroot/
BuildRequires:	perl >= 5.5.0

# '(not relocateable)' if absent
Prefix:		/usr


%description
This utility usually runned as cron task.
On each call it builds list of processes and matches each of processes
against conditions list readed from configuration file.
If process matched conditions, specified action performed.
Action is shell command. Usually it is L<renice(8)> or L<kill(1)>.
For security reasons it is preferred to run kickproc from separate
non-root user and use L<super(1)> or L<sudo(8)> to perform actions.
.
Usually kickproc used by system admin to renice long running
user computing tasks and to kill suspended/deadlocked applications like
Midnight Commander, Acroread, Mozilla.


%prep
%setup -q -n %{name}-%{version}
#%patch


%build
make #OPTIMIZE="$RPM_OPT_FLAGS"


%install
rm -rf $RPM_BUILD_ROOT
%makeinstall PREFIX=$RPM_BUILD_ROOT%{_prefix}

# Remove all empty directories
for i in `find $RPM_BUILD_ROOT -type d | tac`; do
   if [ -d $i ]; then
      rmdir --ign -p $i
   fi
done


%clean
cd ..
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/%{name}-%{version}


%files
%defattr(-,root,root)
%doc INSTALL COPYING
%{_prefix}
