/***************************************************************************
                          khttrackview.h  -  description
                             -------------------
    begin                : lun jun 10 19:13:24 CEST 2002
    copyright            : (C) 2002 by Stphane Chapeau
    email                : nuscly-devel@laposte.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KHTTRACKVIEW_H
#define KHTTRACKVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>

class KhttrackDoc;

/** The KhttrackView class provides the view widget for the KhttrackApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KhttrackView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KhttrackApp class to manipulate and display
 * the document structure provided by the KhttrackDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KhttrackView : public QWidget
{
  Q_OBJECT
  public:
    /** Constructor for the main view */
    KhttrackView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~KhttrackView();

    /** returns a pointer to the document connected to the view instance. Mind that this method requires a KhttrackApp instance as a parent
     * widget to get to the window document pointer by calling the KhttrackApp::getDocument() method.
     *
     * @see KhttrackApp#getDocument
     */
    KhttrackDoc *getDocument() const;

    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);
	
  private:
	
};

#endif // KHTTRACKVIEW_H
