/***************************************************************************
                          khttrackmainwizard.cpp  -  description
                             -------------------
    begin                : Wed Jun 19 2002
    copyright            : (C) 2002 by Stphane Chapeau
    email                : nuscly-devel@laposte.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h> // strcpy
#include <stdio.h>
#include <klocale.h>  // i18n
#include <qmessagebox.h>
#include <khtml_part.h>

#include "khttrackmainwizard.h"
#include "qpushbutton.h"


extern char httrackCmd[500][1024] ;

KhttrackMainWizard::KhttrackMainWizard(QWidget *parent, const char *name ) : MainWizard(parent,name) {

  /* Dialog Box Init */
}
KhttrackMainWizard::~KhttrackMainWizard(){
}

void KhttrackMainWizard::slotAction()
{
    project->s_project.gene_action = ActionCombo->currentItem() ;
}

void KhttrackMainWizard::slotOption()
{
    options->show() ;
    qWarning( "KhttrackMainWizard::slotOption(): Affichage!" );
}

void KhttrackMainWizard::slotProjectBrowse()
{
    qWarning( "KhttrackMainWizard::slotProjectBrowse(): Pas encore implment!" );
}

void KhttrackMainWizard::slotProjectInfo()
{
    QString MyString ;
    MyString = MultiLineEdit2->text() ;
    strcpy(project->s_project.gene_projectInfo, MyString.latin1() );
}

void KhttrackMainWizard::slotProjectName()
{
    QString ProjectName ;
    QString ProjectName2 ;
    QString ProjectName3 ;

    //ProjectName = ComboBoxProject->text()
    ProjectName = ComboBoxProject->currentText() ;
    /*
    QString s("TeX");
    QString t = s.upper();
    */


    //ComboBoxProject->setMaxLength( 254 );

    // Permet d'activer ou non le bouton NEXT
    if ( !ProjectName.isEmpty() )
        setNextEnabled( Page1, TRUE);
    /************* Example de lecture-ecriture Qstring - char

    QString ProjectName ;
    QString ProjectName2 ;
    char test256[256];
    strcpy( test256, ProjectName.latin1() );
    printf("test256=%s\n",test256);
    ProjectName2 = QString( test256 );
    qWarning( ProjectName );
    qWarning( ProjectName2 );
    ****************/

    strcpy(project->s_project.gene_projectName, ProjectName.latin1() );
    ProjectName2 = QString(project->s_project.gene_projectName);



}

void KhttrackMainWizard::slotProjectPath()
{
    QString MyString ;
    MyString = EditProjectPath->text() ;
/*
    QString s = "banana";
    s.replace( QRegExp("a.*a"), "" );           // becomes "b"

    QString s = "banana";
    s.replace( QRegExp("^[bn]a"), " " );        // becomes " nana"

    QString s = "banana";
    s.replace( QRegExp("^[bn]a"), "" );         // NOTE! becomes ""
*/

    strcpy(project->s_project.gene_projectPath, MyString.latin1() );
}

void KhttrackMainWizard::slotStartHour()
{
    qWarning( "KhttrackMainWizard::slotStartHour(): Pas encore implment!" );
}

void KhttrackMainWizard::slotStartNow()
{
    if (LaunchNow->isChecked())
    {
        //setFinishEnabled(MainWizard);
        setFinishEnabled( Page3, TRUE);
    }
}

void KhttrackMainWizard::slotStartSave()
{
    qWarning( "KhttrackMainWizard::slotStartSave(): Pas encore implment!" );
}

void KhttrackMainWizard::slotTimeHour()
{
    qWarning( "KhttrackMainWizard::slotTimeHour(): Pas encore implment!" );
}

void KhttrackMainWizard::slotTimeMin()
{
    qWarning( "KhttrackMainWizard::slotTimeMin(): Pas encore implment!" );
}

void KhttrackMainWizard::slotTimeSec()
{
    qWarning( "KhttrackMainWizard::slotTimeSec(): Pas encore implment!" );
}

void KhttrackMainWizard::slotUrlAdd()
{
    qWarning( "KhttrackMainWizard::slotUrlEdit(): Pas encore implment!" );

    qWarning( "KhttrackMainWizard::slotUrlAdd(): Pas encore implment!" );
}

void KhttrackMainWizard::slotUrlBrowse()
{
    qWarning( "KhttrackMainWizard::slotUrlBrowse(): Pas encore implment!" );
}

void KhttrackMainWizard::slotUrlEdit()
{
    QString MyStringUrl ;
//    MyStringUrl = EditProjectPath->text() ;
    MyStringUrl = URLEdit->text() ;
    MyStringUrl.replace( QRegExp("\\n"), " " );
    strcpy(project->s_project.gene_url, MyStringUrl.latin1() );
    setNextEnabled( Page2, TRUE);
}

void KhttrackMainWizard::slotUrlPath()
{
    qWarning( "KhttrackMainWizard::slotUrlPath(): Pas encore implment!" );
}
/** No descriptions */
void KhttrackMainWizard::initWizard(){

  // Creation de la fenetre d'option
  options = new KhttrackOptions(this);
  options->project = project;   // initialise le pointeur sur le projet
  // Permet d'activer ou non le bouton NEXT
  setNextEnabled( Page1, FALSE);
  setNextEnabled( Page2, FALSE);
  setFinishEnabled( Page3, FALSE);
}
/** Implmntation de la classe virtuelle quand on clique sur finish : lance le moteur */
void KhttrackMainWizard::accept(){

    options->hide();
    hide();
    project->generateCmd() ;
    qWarning( httrackCmd[1] );
    kMirrorView->launch();
}
/** Implmntation de la classe virtuelle quand on clique sur finish : lance le moteur */
void KhttrackMainWizard::help()
{
    options->htmlHelp();
}
