<h1><a name="top" id="top">Bootloader</a></h1>
<p>Dieser Abschnitt besch&auml;ftigt sich mit 
<a href="#lilo">LILO</a> und mit <a href="#grub">GRUB</a>.
</p>

<h2><a name="lilo" id="lilo">LILO (Linux Loader)</a></h2>
<p>
LILO hat seine Konfigurations-Datei unter <span class="c2">/etc/lilo.conf</span>
verstaut.<br />
F&uuml;r Ihren neuen Kernel k&ouml;nnte sie vielleicht so aussehen
(Ausschnitt):
</p>

<div class="example">
	<pre style="font-size:10px;">
# /etc/lilo.conf - See: `lilo(8)' and `lilo.conf(5)',
# ---------------       `install-mbr(8)', `/usr/share/doc/lilo/'
#                       and `/usr/share/doc/mbr/'.
# +---------------------------------------------------------------+
# |                        !! Reminder !!                         |
# |                                                               |
# | Don't forget to run `lilo' after you make changes to this     |
# | conffile, `/boot/bootmess.txt', or install a new kernel.  The |
# | computer will most likely fail to boot if a kernel-image      |
# | post-install script or you don't remember to run `lilo'.      |
# |                                                               |
# +---------------------------------------------------------------+
	</pre>
# [...]<br />
<br />
# Boot Linux standardm&auml;&szlig;ig<br />
#<br />
default=Linux<br />
<br />
image="/boot/bzImage"<br />
label="Linux"<br />
restricted<br />
# append="hdc=ide-scsi"<br />
# weitere Kernel-Optionen<br />
<br />
image="/boot/bzImage.old"<br />
label="LinuxOLD"<br />
restricted
</div>

<p>
Weitere Informationen zu LILO finden Sie unter 
<a onclick="window.open(this.href,'_blank');return false;" href="http://www.lilo.org/">
lilo.org</a>
</p>
<ins><a href="#top">&gt; nach oben &lt;</a></ins>

<h2><a name="grub" id="grub">GRUB (Grand Unified Bootloader)</a></h2>
<p>
Zuerst sollten Sie sicherstellen, dass sich auf Ihrem System
bereits eine vollst&auml;ndige Installation von GRUB befindet.
</p>
<p>
Um GRUB auf eine Floppy zu schreiben, von der Sie dann booten
k&ouml;nnen, tun Sie bitte folgendes auf ihrem
GNU/Linux-System:
</p>

<div class="example">
$ su<br />
<br />
# cd /usr/share/grub/i386-pc
<div class="c1">oder bei manchen Distributionen:</div>
# cd /usr/lib/grub/i386-pc<br />
<br />
# dd if=stage1 of=/dev/fd0 bs=512 count=1<br />
1+0 records in<br />
1+0 records out<br />
# dd if=stage2 of=/dev/fd0 bs=512 seek=1<br />
153+1 records in<br />
153+1 records out
</div>

<p>&nbsp;</p>
<p>
Es existiert eine weitere Option bei GRUB. Man kann eine
Floppy-Disc zwar booten lassen, aber der Kernel existiert auf der
Festplatte. Dies wird realisiert mit:
</p>

<div class="example"># grub<br />
grub&gt; root (hd0,0)<br />
grub&gt; setup(fd0)<br />
grub&gt; quit
</div>
<p>&nbsp;</p>

<p>
Um GRUB dauerhaft auf Ihre Festplatte zu schreiben, benutzen Sie
bitte folgenden Befehl:
</p>

<div class="example">
# grub-install /dev/hda<br />
Probing devices to guess BIOS drives. This may take a long time.<br />
Installation finished. No error reported.<br />
This is the contents of the device map /boot/grub/device.map.<br />
Check if this is correct or not. If any of the lines is incorrect,<br />
fix it and re-run the script `grub-install'.<br />
<br />
(fd0) /dev/fd0<br />
(hd0) /dev/hda<br />
(hd1) /dev/hdb<br />
[...]
</div>

<p>
Unter Umst&auml;nden m&uuml;ssen Sie <span class="c2">/dev/hda</span> Ihren
richtigen Speicher noch anpassen.<br />
Es sollte aber an dieser Stelle auch gesagt sein, dass <span class="c2">grub
install</span> bei mehreren Platten zu Problemen f&uuml;hren kann. Um
GRUB auf eine Partition zu schreiben, k&ouml;nnten die Befehle
folgenderma&szlig;en aussehen:
</p>

<div class="example">
# grub<br />
grub&gt; root (hd0,0)<br />
grub&gt; find /boot/grub/stage1<br />
grub&gt; setup (hd0) <span class="c2">(MBR-Installation)</span><br />
grub&gt; setup (hd0,0) <span class="c2">(Installation in Bootsektor von
'0')</span>
</div>

<p>
Um dann GNU/Linux direkt booten zu k&ouml;nnen, geben Sie beim
Boot-Vorgang einfach folgendes ein:
</p>

<div class="example">
grub&gt; kernel /bzImage root=/dev/hda1<br />
grub&gt; boot
</div>

<p>
Oder Sie legen sich eine dauerhafte Konfiguration von GRUB an,
um beim Booten nur noch aus einem Men&uuml; ausw&auml;hlen zu
m&uuml;ssen.<br />
Diese Datei hei&szlig;t menu.lst und liegt unterhalb Ihres
boot-Verzeichnisses (<span class="c2">/boot/grub/menu.lst</span>). Sie k&ouml;nnte
wiefolgt aussehen:
</p>

<div class="example">
#<br />
# Sample boot menu configuration file<br />
#<br />
<br />
# Standardm&auml;&szlig;ig, starte den ersten Eintrag<br />
default 0<br />
<br />
# Starte automatisch nach 30 Sekunden<br />
timeout 30<br />
<br />
# Falls -warum auch immer- der erste Eintrag nicht
funktioniert,<br />
# benutze den zweiten<br />
fallback 1<br />
<br />
# F&uuml;r GNU/Hurd (von der ersten Festplatte, zweite
Partition)<br />
title GNU/Hurd<br />
root (hd0,1)<br />
kernel /boot/gnumach.gz root=hd0s1<br />
module /boot/serverboot.gz<br />
<br />
# F&uuml;r GNU/Linux (von der zweiten Festplatte)<br />
title GNU/Linux<br />
kernel (hd1,0)/bzImage root=/dev/hdb1<br />
<br />
# F&uuml;r Windows NT oder Windows95 (von der ersten
Festplatte)<br />
title Windows NT / Windows 95 boot menu<br />
root (hd0,0)<br />
makeactive<br />
chainloader +1<br />
# F&uuml;r DOS, wenn Windows NT installiert ist<br />
# chainload /bootsect.dos
</div>

<p>
Weiterf&uuml;hrende Informationen zu GRUB erhalten Sie unter
<a onclick="window.open(this.href,'_blank');return false;" href="http://www.gnu.org/software/grub/manual/html_mono/grub.html">
gnu.org/software/grub/manual/html_mono/grub.html</a>
</p>
<ins><a href="#top">&gt; nach oben &lt;</a></ins>

