/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2008  John Schneiderman <JohnMS@member.fsf.org>                         *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef WALLYCRAZYEIGHTSAI_H
#define WALLYCRAZYEIGHTSAI_H

#include "cardsequence.h"
#include "gameinformation.h"
class RuleBase;

/**
 * This is the "brain" for Wally for the game of Crazy Eights.
 *
 * @author John Schneiderman
 */
class WallyCrazyEightsAI
{
public:
    /**
     * Basic constructor.
     * @param playSequence is the current play sequence.
     * @param rules is the rules being used in the game.
     * @param hand is the current hand.
     * @param specialInformation is any special information for the player to consider.
     */
    WallyCrazyEightsAI(const CardSequence &playSequence, const RuleBase &rules, const CardSequence &hand, const GameInformation &specialInformation);
    /**
     * Destructor.
     */
    ~WallyCrazyEightsAI();
    /**
     * Selects a card to play.
     * @note A blank card (--) is returned if the player chooses to draw a card or pass instead of playing a card.
     * @return the front card is the card selected.
     */
    CardSequence selectCard() const;
    /**
     * Selects a suit to declare when playing an eight.
     * @param score is the current player's score.
     * @return the suit selected.
     */
    Card::Suit selectSuit(int score) const;

private:
    /// @param m_playSequence is the current play sequence.
    CardSequence m_playSequence;
    /// @param m_pRules is the current rule base.
    const RuleBase *m_pRules;
    /// @param m_hand is the players hand.
    CardSequence m_hand;
    /// @param m_specialInformation is the special information passed to the player.
    GameInformation m_specialInformation;
};
#endif
