/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2006-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef HEARTSPLAYER_H
#define HEARTSPLAYER_H

#include "computerplayer.h"
#include "heartsrules.h"

class AIBase;

/**
 * This is a computer player for the game of hearts.
 *
 * @author John Schneiderman
 */
class HeartsPlayer: public ComputerPlayer
{
public:
    /**
     * The general constructor.
     * @param aiBase is the AI for our computer player.
     */
    HeartsPlayer(AIBase &aiBase);
    /**
     * The default destructor.
     */
    ~HeartsPlayer();
    /**
     * Requests that the AI choose a card for game play.
     * @param playSequence is the current play sequence.
     * @return the card the AI has chosen.
     */
    virtual Card playCard(const CardSequence& playSequence) const;
    /**
     * Requests that the AI choose cards to pass.
     * @param playSequence is the current play sequence.
     * @return the cards the AI has chosen to pass.
     */
    CardSequence passCards(const CardSequence& playSequence) const;

private:
    /// @param m_rules are the rules for the game of Hearts.
    HeartsRules m_rules;
};
#endif
