/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2007-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "suitrequest.h"
#include "kardsgterror.h"

#include <QPushButton>
#include <QLabel>
#include <QComboBox>
#include <QLayout>
#include <QVBoxLayout>
#include <QHBoxLayout>

SuitRequest::SuitRequest(const QString &caption, bool canPass, bool canBidNoSuit, QWidget *parent, bool modal): QDialog(parent)
{
    if (parent)
        setMaximumSize(parent->width(), parent->height());
    setWindowTitle(caption);
    setModal(modal);
    m_pLayout = new QVBoxLayout(this);
    m_canBidNoSuit = canBidNoSuit;

    // Create instructions label
    m_pLblInstructions = new QLabel();
    m_pLblInstructions->setText("Please select a suit:");
    m_pLayout->addWidget(m_pLblInstructions);

    // Create horizontal layout for spin box and button
    QHBoxLayout *m_pSpinBoxButtonLayout = new QHBoxLayout();

    // Create Combo Box
    m_pCmbBxSuit = new QComboBox();
    m_pCmbBxSuit->addItem("Spades");
    m_pCmbBxSuit->addItem("Hearts");
    m_pCmbBxSuit->addItem("Clubs");
    m_pCmbBxSuit->addItem("Diamonds");
    if (canBidNoSuit)
        m_pCmbBxSuit->addItem("No Suit");
    if (canPass)
        m_pCmbBxSuit->addItem("Pass");
    m_pCmbBxSuit->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    m_pSpinBoxButtonLayout->addSpacing(15);
    m_pSpinBoxButtonLayout->addWidget(m_pCmbBxSuit);
    // Create Button
    m_pBttnSuit = new QPushButton();
    m_pBttnSuit->setText("Select");
    m_pBttnSuit->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    connect(m_pBttnSuit, SIGNAL(clicked()), this, SLOT(accept()));
    m_pSpinBoxButtonLayout->addSpacing(30);
    m_pSpinBoxButtonLayout->addWidget(m_pBttnSuit);
    m_pSpinBoxButtonLayout->addSpacing(15);

    m_pLayout->addLayout(m_pSpinBoxButtonLayout);
    setLayout(m_pLayout);
}

SuitRequest::~SuitRequest()
{
    delete m_pBttnSuit;
    delete m_pLblInstructions;
    delete m_pCmbBxSuit;
    delete m_pLayout;
}

Card::Suit SuitRequest::suit() const
{
    Card::Suit selectedSuit;

    switch (m_pCmbBxSuit->currentIndex())
    {
    case 0:
        selectedSuit = Card::SPADES;
        break;
    case 1:
        selectedSuit = Card::HEARTS;
        break;
    case 2:
        selectedSuit = Card::CLUBS;
        break;
    case 3:
        selectedSuit = Card::DIAMONDS;
        break;
    case 4:
        if (m_canBidNoSuit)
            selectedSuit = Card::NO_SUIT;
        else
            selectedSuit = Card::SUIT_ERR;
        break;
    case 5:
        selectedSuit = Card::SUIT_ERR;
        break;
    default:
        throw KardsGTError("SuitRequest", "suit", "Failed to determine suit selection!");
    }
    return selectedSuit;
}
