/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2008  John Schneiderman <JohnMS@member.fsf.org>                         *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef CONFIGURE_KARDSGT_H
#define CONFIGURE_KARDSGT_H

#include "ui_configurekardsgt.h"

class UserProfileDatabase;

/**
 * This is the dialogue to ask the user to change settings in the card game. These are for
 * system wide settings stored in the UserProfileDatabase.
 * 
 * @author John Schneiderman
 */
class ConfigureKardsGT: public QDialog, public Ui::ConfigureKardsGT
{
    Q_OBJECT

public:
    /**
     * The general constructor.
     * @param database is the database for the user settings.
     * @param parent is the parent widget.
     */
    ConfigureKardsGT(const UserProfileDatabase &database, QWidget *parent);
    /**
     * Gives the path to where the card front images are stored.
     * @return the path to the card front images.
     */
    QString cardFrontImagePath() const;
    /**
     * Gives the file-name and path to the card back image.
     * @return the file-name for the card back image.
     */
    QString cardBackImageFilename() const;
    /**
     * Gives the file-name and path to the neutral mood image.
     * @return the file-name for the neutral mood.
     */
    QString neutralMoodFilename() const;

private slots:
    /**
     * This updates the card back image being displayed when the selection changes.
     */
    void cardBackChange();
    /**
     * This opens a dialogue for the user to enter/select the file-name for the card back image.
     */
    void setCardBackImageFilename();
    /**
     * This opens a dialogue for the user to enter/select the path to the directory that stores the card front images.
     */
    void setCardFrontImagePath();
    /**
     * This opens a dialogue for the user to enter/select the file-name for the neutral mood.
     */
    void setNeutralMoodFilename();
    /**
     * This displays a dialogue that informs the user how to use the configuration dialogue.
     */
    void displayHelp();
    /**
     * This sets all the options to their defaults.
     */
    void setDefaults();
};
#endif
