/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2006-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef CRIBBAGEAI_H
#define CRIBBAGEAI_H

#include "cardsequence.h"
#include "rulebase.h"

/**
 * This is the decision making part for Wally on how to play Cribbage.
 *
 * @author John Schneiderman
 */
class WallyCribbageAI
{
public:
    /**
     * This is the default constructor.
     * @param playSequence is the current play sequence in Cribbage.
     * @param rules are the rules for Cribbage.
     * @param hand is the current hand we're playing with.
     */
    WallyCribbageAI(const CardSequence &playSequence, const RuleBase &rules, const CardSequence &hand);
    /**
     * Default destructor.
     */
    ~WallyCribbageAI();
    /**
     * Selects a card to play.
     * @return the card selected.
     */
    CardSequence selectCards() const;
    /**
     * Selects two cards to pass to the crib when Wally is a dealer.
     * @return the cards Wally has selected.
     */
    CardSequence selectDealersCribCards() const;
    /**
     * Selects two cards to pass to the crib when Wally is not the dealer.
     * @return the cards Wally has selected.
     */
    CardSequence selectNonDealersCribCards() const;

private:
    /// @param m_playSequence is the play sequence we're working with.
    CardSequence m_playSequence;
    /// @param m_hand is the hand of cards we're working with.
    CardSequence m_hand;
    /// @param m_pRules are the rules for the game.
    const RuleBase *m_pRules;
};
#endif
