/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2008  John Schneiderman <JohnMS@member.fsf.org>                         *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "abigailcrazyeightsai.h"
#include "basicgamestrategies.h"
#include "kardsgterror.h"
#include "../../games/crazyeights/crazyeightsrules.h"
#include <cmath>

#include <QtDebug>

AbigailCrazyEightsAI::AbigailCrazyEightsAI(const CardSequence &playSequence, const RuleBase &rules, const CardSequence &hand, const GameInformation &specialInformation)
{
    time_t seconds;

    m_playSequence = playSequence;
    m_pRules = &rules;
    m_hand = hand;
    m_specialInformation = specialInformation;
    time(&seconds);
    srand(seconds);
}

AbigailCrazyEightsAI::~AbigailCrazyEightsAI()
{
}

CardSequence AbigailCrazyEightsAI::selectCard() const
{
    CardSequence selection;
    Card::Rank leadRank = m_playSequence.front().rank();
    Card::Suit leadSuit = m_playSequence.front().suit();
    BasicGameStrategies basicStrategy(*m_pRules);

    // Determine if we have the lead suit
    if (m_hand.hasSuit(leadSuit))
    {
        // Find the highest card to play
        selection.addCard(basicStrategy.highestCardOfSuit(m_hand, leadSuit));
        qDebug() << "     AbigailCrazyEightsAI, Playing the highest card: " << selection;
    }
    else
    {
        // See if we have a card of the same rank to play and we "see" the opportunity
        if (m_hand.hasRank(leadRank) && ((rand() % 100) > 49))
        {
            for (int index = 0, size = m_hand.size(); index < size; ++index)
                if (m_hand[index].rank() == leadRank)
                {
                    selection.addCard(m_hand[index]);
                    break;
                }
            qDebug() << "     AbigailCrazyEightsAI, Playing the lead rank: " << selection;
        }
        else if (m_hand.hasRank(Card::EIGHT)) // Play an eight
        {
            for (int index = 0, size = m_hand.size(); index < size; ++index)
                if (m_hand[index].rank() == Card::EIGHT)
                {
                    selection.addCard(m_hand[index]);
                    break;
                }
            qDebug() << "     AbigailCrazyEightsAI, Playing the eight: " << selection;
        }
        else // Return a blank card to indicate we need to draw a card or pass
        {
            selection.addCard(Card());
            qDebug() << "     AbigailCrazyEightsAI, Pass or drawing: " << selection;
        }
    }
    return selection;
}

Card::Suit AbigailCrazyEightsAI::selectSuit(int ) const
{
    Card::Suit suit = Card::SUIT_ERR;
    BasicGameStrategies basicStrategy(*m_pRules);
    int numberOfCardsInHighSuit = -1;
    int numberOfCards = -1;

    for (int index = 0; index < Card::NUMBER_OF_SUITS; ++index)
    {
        numberOfCards = basicStrategy.numberOfCardsOfSuit(m_hand, static_cast<Card::Suit>(index));
        if (numberOfCards > numberOfCardsInHighSuit)
        {
            numberOfCardsInHighSuit = numberOfCards;
            suit = static_cast<Card::Suit>(index);
        }
    }
    qDebug() << "     AbigailCrazyEightsAI, Changing suit to: " << suit;
    return suit;
}
