/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2006-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "warplayer.h"

WarPlayer::WarPlayer(AIBase &aiBase): ComputerPlayer(aiBase), m_rules()
{}

WarPlayer::~WarPlayer()
{}

Card WarPlayer::playCard(const CardSequence &playSequence) const
{
    if ( isTurn() )
        return m_pAIBase->whichCards("war", playSequence, m_rules, m_hand, m_gameInformation).front();
    else
        return Card();
}
