/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2006-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef BIDREQUEST_H
#define BIDREQUEST_H

#include <QDialog>

class QPushButton;
class QLabel;
class QSpinBox;
class QVBoxLayout;

/**
 * This requests a bid from a human player.
 *
 * @author John Schneiderman
 */
class BidRequest: public QDialog
{
    Q_OBJECT

public:
    /**
     * Constructor for a bid request widget dialogue.
     * @param caption is the caption for the dialogue.
     * @param minimum is the minimum that a player can bid.
     * @param maximum is the maximum that a player can bid.
     * @param specialText is the text to display instead of the minimum value.
     * @param parent is the parent of our dialogue.
     * @param modal is true if we want our dialogue to be modal, false elsewise.
     */
    BidRequest(const QString &caption, int minimum, int maximum, const QString &specialText="NONE", QWidget *parent=0, bool modal=true);
    /**
     * The destructor for our dialogue.
     */
    ~BidRequest();
    /**
     * An accessor to the bid the player made.
     * @return the bid the player made.
     */
    int bid() const;

private:
    /// @param m_pBttnBid is the button to select our bid.
    QPushButton* m_pBttnBid;
    /// @param m_pLblInstructions is the instructions for the user.
    QLabel* m_pLblInstructions;
    /// @param m_pSpnbxBid is the bid the player selects from.
    QSpinBox* m_pSpnbxBid;
    /// @param m_pLayout is the layout to hold all of our widgets.
    QVBoxLayout *m_pLayout;
};
#endif
