/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2005-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "gamebase.h"
#include "player.h"
#include "computerplayer.h"

#include <QTextStream>

GameBase::GameBase(UserProfileDatabase &profileDatabase): m_players(), m_playSequence(), m_savedHands()
{
    m_roundPoints=0;
    m_dealerIndex=0;
    m_pProfileDatabase=&profileDatabase;
}

GameBase::~GameBase()
{}

void GameBase::addOpponent(ComputerPlayer &opponent)
{
    addPlayer(opponent);
}

void GameBase::addPlayer(Player &player)
{
    m_players.insert(player);
}

void GameBase::resetGame(bool roundOver)
{
    for (int i=0; i < m_players.size(); ++i)
    {
        m_players[i].reset();
        if (roundOver)
            m_players[i].resetRoundScore();
    }
    m_playSequence.clear();
    m_roundPoints=0;
}

void GameBase::nextDealer()
{
    m_players[m_dealerIndex].setDealer(false);
    m_players.setCurrentPlayer(m_players[m_dealerIndex=(m_dealerIndex + 1) % m_players.size()]);
    m_players[m_dealerIndex].setDealer(true);
}

void GameBase::savePlayerHands()
{
    m_savedHands.clear();
    for (int index=0; index < m_players.size(); ++index)
        m_savedHands.push_back(m_players[index].hand());
}

void GameBase::restorePlayerHands()
{
    for (int index=0; index < m_players.size(); ++index)
        m_players[index].hand()=m_savedHands[index];
}

void GameBase::clearPlayerHands()
{
    for (int index=0; index < m_players.size(); ++index)
        m_players[index].hand().clear();
}

void GameBase::saveGameBase(QTextStream &out)
{
    out << "Players: " << endl << m_players << endl;
    out << "RoundPoints: " << m_roundPoints << endl;
    out << "DealerIndex: " << m_dealerIndex << endl;
    out << "PlaySequence: " << m_playSequence << endl;
    out << "NumberOfSavedhands: " << m_savedHands.size() << endl;
    for (int index=0, size=m_savedHands.size(); index < size; ++index)
        out << "SavedHand:" << index << " " << m_savedHands[index] << endl;
}

void GameBase::loadGameBase(QTextStream &in)
{
    QString label="";
    int numberOfSavedHands=0;
    CardSequence savedHands;

    in >> label >> m_players;
    in >> label >> m_roundPoints;
    in >> label >> m_dealerIndex;
    in >> label >> m_playSequence;
    in >> label >> numberOfSavedHands;
    m_savedHands.clear();
    for (int i=0; i < numberOfSavedHands; ++i)
    {
        in >> label  >> savedHands;
        m_savedHands.push_back(savedHands);
    }
}
