/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "bidrequest.h"

#include <qpushbutton.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qlayout.h>

BidRequest::BidRequest(const QString &caption, int minimum, int maximum, const QString &specialText, QWidget *parent, const char *name, bool modal): QDialog(parent, name, modal, WPaintClever | WRepaintNoErase)
{
    setMaximumSize(parent->width(), parent->height());
    setCaption(caption);
    m_pLayout = new QVBoxLayout(this);

    // Create instructions label
    m_pLblInstructions = new QLabel(this, "m_pLblInstructions");
    if (specialText != "NONE")
        m_pLblInstructions->setText(QString("Bid range:\n Minimum bid: %1\n Maximum bid: %2").arg(specialText).arg(maximum));
    else
        m_pLblInstructions->setText(QString("Bid range:\n Minimum bid: %1\n Maximum bid: %2").arg(minimum).arg(maximum));
    m_pLayout->addWidget(m_pLblInstructions);

    // Create horizontal layout for spin box and button
    QHBoxLayout *m_pSpinBoxButtonLayout = new QHBoxLayout(m_pLayout);

    // Create Spin Box
    m_pSpnbxBid = new QSpinBox( this, "m_pSpnbxBid" );
    m_pSpnbxBid->setMinValue(minimum);
    m_pSpnbxBid->setMaxValue(maximum);
    if (specialText != "NONE")
        m_pSpnbxBid->setSpecialValueText(specialText);
    m_pSpnbxBid->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    m_pSpinBoxButtonLayout->addSpacing(15);
    m_pSpinBoxButtonLayout->addWidget(m_pSpnbxBid);
    // Create Button
    m_pBttnBid = new QPushButton(this, "m_pBttnBid");
    m_pBttnBid->setText("Place Bid");
    m_pBttnBid->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    connect(m_pBttnBid, SIGNAL(clicked()), this, SLOT(accept()));
    m_pSpinBoxButtonLayout->addSpacing(30);
    m_pSpinBoxButtonLayout->addWidget(m_pBttnBid);
    m_pSpinBoxButtonLayout->addSpacing(15);
}

BidRequest::~BidRequest()
{
    delete m_pBttnBid;
    delete m_pLblInstructions;
    delete m_pSpnbxBid;
    delete m_pLayout;
}

int BidRequest::bid() const
{
    return m_pSpnbxBid->value();
}
