/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include <qwidgetplugin.h>

class QStringList;
class QString;
class QIconSet;
class QWidget;

/**
 * This creates the widget plugins to be used with the QDesigner.
 *
 * @author John Schneiderman
 */
class KardsGTPlugins: public QWidgetPlugin
{
public:
    /**
     * Gives a list of all the keys for the widgets.
     */
    QStringList keys() const;
    /**
     * Creates a new widget for one of our widgets.
     * @param key is the key for the widget we want to create.
     * @param parent is the name of the parent for the widget created.
     * @param name is the name for our widget.
     */
    QWidget * create(const QString &key, QWidget *parent, const char *name);
    /**
     * Gives the include file needed for a widget.
     * @param key is the key to use.
     */
    QString includeFile(const QString &key) const;
    /**
     * The group that one of our widgets belong to.
     * @param key is the key to use.
     */
    QString group(const QString &key) const;
    /**
     * The icon to use with one of our widgets.
     * @param key is the key to use.
     */
    QIconSet iconSet(const QString &key) const;
    /**
     * The tool tip for one ouf our widgets.
     * @param key is the key to use.
     */
    QString toolTip(const QString &key) const;
    /**
     * The what is this statment for one of our widgets.
     * @param key is the key to use.
     */
    QString whatsThis(const QString &key) const;
    /**
     * Determines if one of our keys is a container.
     * @param key is the key to use.
     */
    bool isContainer(const QString &key) const;
};
