/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef COMPUTERPLAYER_H
#define COMPUTERPLAYER_H

#include "player.h"

class AIBase;
class Card;
class CardSequence;

/**
 * This is the basic interface for all AI/network card players.
 * This class is used in the same manner as the Player class is used.
 *
 * @author John Schneiderman
 */
class ComputerPlayer: public Player
{
public:
    /**
     * Default constructor.
     * @param aiBase is the "brain" for our computer player.
     */
    ComputerPlayer(AIBase &aiBase);
    /**
     * Destructor.
     * @note takes care of the deletion of our AIBase.
     */
    virtual ~ComputerPlayer();
    /**
     * This is used to request that a player play a card.
     * @param playSequence is the current playing sequence for the card game.
     * @return the card the player selects.
     */
    virtual Card playCard(const CardSequence &playSequence) const=0;

protected:
    /// @param m_pAIBase holds all the information on how the computer/network player is to play a specific game.
    AIBase *m_pAIBase;
};
#endif
