/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "kardsgtplugins.h"
#include "../gamebase/widgets/kard.h"
#include "../gamebase/widgets/kardplayer.h"
#include "../gamebase/widgets/kardpile.h"
#include "../gamebase/widgets/kardsequence.h"
#include "../gamebase/widgets/kardplaysequence.h"
#include "../games/cribbage/cribbageboard.h"

#include <qstringlist.h>
#include <qstring.h>
#include <qiconset.h>
#include <qwidget.h>
#include <qimage.h>

QStringList KardsGTPlugins::keys() const
{
     QStringList list;

     list.append("Kard");
     list.append("KardPlayer");
     list.append("KardPile");
     list.append("KardSequence");
     list.append("KardPlaySequence");
     list.append("CribbageBoard");
     return list;
}

QWidget * KardsGTPlugins::create(const QString &key, QWidget *parent, const char *name)
{
     if (key == "Kard")
          return new Kard(parent, name);
     else if (key == "KardPlayer")
          return new KardPlayer(parent, name);
     else if (key == "KardPile")
          return new KardPile(parent, name);
     else if (key == "KardSequence")
          return new KardSequence(parent, name);
     else if (key == "KardPlaySequence")
          return new KardPlaySequence(parent, name);
     else if (key == "CribbageBoard")
          return new CribbageBoard(parent, name);
     else
          return new QWidget(parent, name);
}

QString KardsGTPlugins::includeFile(const QString &key) const
{
     if (key == "Kard")
          return "kard.h";
     else if (key == "KardPile")
          return "kardpile.h";
     else if (key == "KardPlayer")
          return "kardplayer.h";
     else if (key == "KardSequence")
          return "kardsequence.h";
     else if (key == "KardPlaySequence")
          return "kardplaysequence.h";
     else if (key == "CribbageBoard")
          return "cribbageboard.h";
     else
          return "";
}

bool KardsGTPlugins::isContainer(const QString &key) const
{
     if ((key == "KardPile") || (key == "KardSequence") || (key == "KardPlaySequence"))
          return false;
     else
          return true;
}

QString KardsGTPlugins::group(const QString &key) const
{
     if ((key == "Kard") || (key == "KardPile") || (key == "KardPlayer") || (key == "KardSequence") || (key == "KardPlaySequence") || (key == "CribbageBoard"))
          return "KardsGT";
     else
          return "";
}

QIconSet KardsGTPlugins::iconSet(const QString &key) const
{
     if (key == "Kard")
          return QIconSet(QImage::fromMimeSource("KardWidget.png"));
     else if (key == "KardPlayer")
          return QIconSet(QImage::fromMimeSource("KardPlayerWidget.png"));
     else if (key == "KardPile")
          return QIconSet(QImage::fromMimeSource("KardPileWidget.png"));
     else if (key == "KardSequence")
          return QIconSet(QImage::fromMimeSource("KardSequenceWidget.png"));
     else if (key == "KardPlaySequence")
          return QIconSet(QImage::fromMimeSource("KardPlaySequenceWidget.png"));
     else if (key == "CribbageBoard")
          return QIconSet(QImage::fromMimeSource("CribbageBoardWidget.png"));
     else
          return QIconSet();
}

QString KardsGTPlugins::toolTip(const QString &key) const
{
     if (key == "Kard")
          return "A Playing Card";
     else if (key == "KardPlayer")
          return "A card player";
     else if (key == "KardPile")
          return "A pile of cards";
     else if (key == "KardSequence")
          return "A sequence of cards.";
     else if (key == "KardPlaySequence")
          return "A playing sequence of cards.";
     else if (key == "CribbageBoard")
          return "A Cribbage Board";
     else
          return "";
}

QString KardsGTPlugins::whatsThis(const QString &key) const
{
     if (key == "Kard")
          return "A widget for drawing a Kard.";
     else if (key == "KardPlayer")
          return "A widget for drawing a card player.";
     else if (key == "KardPile")
          return "A widget for drawing a pile of cards.";
     else if (key == "KardSequence")
          return "A widget for drawing a sequence of cards.";
     else if (key == "KardPlaySequence")
          return "A widget for drawing the playing sequence of cards.";
     else if (key == "CribbageBoard")
          return "A widget for drawing a cribbage board.";
     else
          return "";
}

Q_EXPORT_PLUGIN(KardsGTPlugins)
