/***************************************************************************
 *   Copyright (C) 2007 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef OLD_MAID_INTERFACE_H
#define OLD_MAID_INTERFACE_H

#include "oldmaid.h"
#include "oldmaidinterfacebase.h"
#include "kardplayer.h"
#include "kardsequence.h"
#include "userprofiledatabase.h"

#include <qwidget.h>
#include <vector>
using std::vector;

/**
 * This is the interface for a game of Old Maid.
 *
 * @author John Schneiderman
 */
class OldMaidInterface: public OldMaidInterfaceBase, public OldMaid
{
    Q_OBJECT

public:
    /**
     * This is the general constructor.
     * @param profileDatabase is the user profile database.
     * @param parent is our parent widget.
     * @param name is the name of us.
     */
    OldMaidInterface(UserProfileDatabase &profileDatabase, QWidget *parent = 0, const char *name = 0);
    /**
     * General destructor.
     */
    ~OldMaidInterface();
    /**
     * Updates the display of the game.
     */
    void updateTable();
    /**
     * Requests that the human player discard his pairs.
     */
    CardSequence discardPairs();
    /**
     * This displays a message to a player.
     * @param player is the player to see the message.
     * @param message is the message for the player to see.
     */
    void displayMessage(const Player &player, const QString &message);
    /**
     * This prompts a message.
     * @param caption is caption for the message displayed.
     * @param message is the message for the player to see.
     */
    void promptMessage(const QString &caption, const QString &message);
    /**
     * Displays the ending game scores, and who won.
     * @throw KardsGTError if we cannot determine who won.
     */
    void gameWon();
    /**
     * Resets the display to the original setup.
     */
    void reset();
    /**
     * Shows the pairs a player has discarded.
     */
    void showDiscardedPairs(const QString &name, const CardSequence &pairs);

protected slots:
    /**
     * This slot handles the kard selected by a player.
     * @param kard is the card the player selected.
     */
    void playerCardPlayed(Kard &kard);
    /**
     * Saves the player's new card arrangement.
     */
    void playerCardMoved();

private:
    /**
     * These are the number of ms to launch each timer.
     * @param COMPUTER_PLAYER_TIME is how often to check to see if a computer player can play.
     * @param CLEARING_DELAY_TIME is how long our delay should be before we clear the playing sequence.
     * @note This should be less than the time for a computer player to play.
     */
    enum TimerLengths { COMPUTER_PLAYER_TIME=1500, CLEARING_DELAY_TIME=500 };

    /// @param m_computerTimerId is the id for the timer for the computer player.
    int m_computerTimerId;
    /// @param m_clearingDelayId is the id for the timer for the clearing delay.
    int m_clearingDelayId;
    /// @param m_pUserProfile is the user profile database.
    const UserProfileDatabase *m_pUserProfile;
    /// @param m_kardPlayers are the images of the players.
    vector<KardPlayer *> m_kardPlayers;
    /// @param m_playersHands are the hand containers for each player.
    vector<KardSequence *> m_playersHands;

    /**
     * This handles the timer events.
     * @param event is the generating event.
     */
    void timerEvent(QTimerEvent *event);
    /**
     * This handles the computer card playing.
     * @param playerIndex is the index of the player who should play a card.
     * @throw KardsGTError if the playerIndex is the third player or a non-player.
     */
    void computerPlay(int playerIndex);
};
#endif
