/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "kardsgterror.h"
#include <qstring.h>

KardsGTError::KardsGTError(const char * name, const char * method, const char * message): runtime_error(message)
{
    m_pName=new QString(name);
    m_pMethod=new QString(method);
    m_pMessage=new QString(message);
}

KardsGTError::KardsGTError(QString name, QString method, QString message): runtime_error(name + ", " + method + "(...): " + message)
{
    m_pName=new QString(name);
    m_pMethod=new QString(method);
    m_pMessage=new QString(message);
}

KardsGTError::KardsGTError(const KardsGTError &kardsGTError): runtime_error(kardsGTError.className() + ", " + kardsGTError.classMethod() + "(...): " + kardsGTError.errorMessage())
{
    m_pName=new QString(kardsGTError.className());
    m_pMethod=new QString(kardsGTError.classMethod());
    m_pMessage=new QString(kardsGTError.errorMessage());
}

KardsGTError::~KardsGTError() throw()
{
    if (m_pName != NULL)
        delete m_pName;
    if (m_pMethod != NULL)
        delete m_pMethod;
    if (m_pMessage != NULL)
        delete m_pMessage;
}

QString KardsGTError::errorMessage() const
{
    return *m_pMessage;
}

QString KardsGTError::className() const
{
    return *m_pName;
}

QString KardsGTError::classMethod() const
{
    return *m_pMethod;
}

ostream& operator<<(ostream &out, const KardsGTError &error)
{
    out << error.className() << ", " << error.classMethod() << "(...): " << error.errorMessage();
    return out;
}

bool KardsGTError::operator==(const KardsGTError &error) const
{
    if ((className() != error.className()) ||  (classMethod() != error.classMethod()) || (errorMessage() != error.errorMessage()))
        return false;
    else
        return true;
}
