/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "warrules.h"
#include "kardsgterror.h"

WarRules::WarRules(): RuleBase()
{}

int WarRules::maximumNumberOfPlayers() const
{
    return MAXIMUM_NUMBER_OF_PLAYERS;
}

int WarRules::minimumNumberOfPlayers() const
{
    return MINIMUM_NUMBER_OF_PLAYERS;
}

int WarRules::winningGameScore() const
{
    return WINNING_GAME_SCORE;
}

int WarRules::numberOfCardsToDeal() const
{
    return NUMBER_OF_CARDS_TO_DEAL;
}

int WarRules::cardValue(const Card &card) const
{
    int value = RANK_ERR;

    switch (card.rank())
    {
    case Card::ACE:
        value=ACE;
        break;
    case Card::TWO:
        value=TWO;
        break;
    case Card::THREE:
        value=THREE;
        break;
    case Card::FOUR:
        value=FOUR;
        break;
    case Card::FIVE:
        value=FIVE;
        break;
    case Card::SIX:
        value=SIX;
        break;
    case Card::SEVEN:
        value=SEVEN;
        break;
    case Card::EIGHT:
        value=EIGHT;
        break;
    case Card::NINE:
        value=NINE;
        break;
    case Card::TEN:
        value=TEN;
        break;
    case Card::JACK:
        value=JACK;
        break;
    case Card::QUEEN:
        value=QUEEN;
        break;
    case Card::KING:
        value=KING;
        break;
    default:
        value=RANK_ERR;
    }
    return value;
}

bool WarRules::isLegalPlay(const CardSequence &, const Card &cardPlayed, const Player &player) const
{
    if (! player.hand().isEmpty())
        if (player.hand().front() == cardPlayed)
            return true;
        else
            return false;
    else
        return false;
}

bool WarRules::isGameOver(const PlayerList &players) const
{
    for (int i = 0; i < players.size(); ++i)
        if (players[i].gamesWon() >= WINNING_GAME_SCORE)
            return true;
        else if (players[i].hand().isEmpty())
            return true;
    return false;
}

bool WarRules::isRoundOver(const PlayerList &) const
{
    throw KardsGTError("WarRules", "isRoundOver", "This is not implemented!");
    return false;
}

bool WarRules::isPhaseOver(const PlayerList &, const CardSequence &) const
{
    throw KardsGTError("WarRules", "isPhaseOver", "This is not implemented!");
    return false;
}

int WarRules::rankValue(const Card &) const
{
    throw KardsGTError("WarRules", "rankValue", "This is not implemented!");
    return Card::RANK_ERR;
}
