/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef WAR_PLAYER_H_
#define WAR_PLAYER_H_

#include "computerplayer.h"
#include "aibase.h"
#include "cardsequence.h"
#include "warrules.h"

/**
 * This is the interface code for a War player.
 */
class WarPlayer: public ComputerPlayer
{
public:
    /**
     * Default constructor.
     * @param aiBase is the AI for the war player.
     */
    WarPlayer(AIBase &aiBase);
    /**
     * Destructor.
     */
    virtual ~WarPlayer();
    /**
     * Plays a card from the player's hand.
     * @param playSequence is the current game play sequence
     */
    virtual Card playCard(const CardSequence &playSequence) const;

private:
    /// @param m_rules are the rules for a game of war.
    WarRules m_rules;
};
#endif
