/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef KARDDISPLAY_H
#define KARDDISPLAY_H

#include "cardsequence.h"

#include <qdialog.h>
#include <qstring.h>
#include <vector>
using std::vector;

class QVBoxLayout;
class QHBoxLayout;
class QPushButton;

/**
 * A dialogue showing card sequences with messages along side those sequences.
 *
 * @author John Schneiderman
 */
class KardMessageDisplay: public QDialog
{
    Q_OBJECT

public:
    /**
     * This is the widget dialogue constructor.
     * @param caption is the caption for the dialogue.
     * @param hands are the card sequences to display.
     * @param messages are the messages to accompany the card sequences.
     * @param cardImagePath is the path to the directory that contains the image of our kards.
     * @param cardBackImage is the filename for the back of our kards.
     * @param parent is the parent of the dialogue.
     * @param name is the name of the dialogue.
     * @param modal is whether or not the dialogue is modal, the default is true.
     * @throw KardsGTError if hands and messages are not paired with each other.
     */
    KardMessageDisplay(const QString &caption, const vector<CardSequence> &hands, const vector<QString> &messages, const QString &cardImagePath, const QString &cardBackImage, QWidget *parent=0, const char *name=0, bool modal=true);
    /**
     * The destructor.
     */
    ~KardMessageDisplay();

private:
    /// @param m_hands are the card sequences to displayed.
    vector<CardSequence> m_hands;
    /// @param m_messages are the messages to display beside each card sequence.
    vector<QString> m_messages;
    /// @param m_pDisplay is the display layout for the whole widget.
    QVBoxLayout *m_pDisplay;
    /// @param m_messageLayouts is the layout for each message.
    vector<QHBoxLayout *> m_messageLayouts;
    /// @param m_pBttnOkay is the button to push to close the dialogue.
    QPushButton *m_pBttnOkay;
};
#endif
