/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *  m_pLayout along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "gameinformation.h"
#include "kardsgterror.h"

#include <qtextstream.h>
using std::iterator;

GameInformation::GameInformation(): m_information()
{}

GameInformation::~GameInformation()
{}

void GameInformation::add
    (const QString &key, int value)
{
    if (key.contains("_") || key.contains("~"))
        throw KardsGTError("GameInformation", "add", "The key cannot conntain a '_' or a '~' in it.");
    m_information[key] = QString("%1").arg(value);
}

void GameInformation::add
    (const QString &key, double value)
{
    if (key.contains("_") || key.contains("~"))
        throw KardsGTError("GameInformation", "add", "The key cannot conntain a '_' or a '~' in it.");
    m_information[key] = QString("%1").arg(value);
}

void GameInformation::add
    (const QString &key, const QString &value)
{
    if (key.contains("_") || key.contains("~"))
        throw KardsGTError("GameInformation", "add", "The key cannot conntain a '_' or a '~' in it.");
    if (value.contains("_") || value.contains("~"))
        throw KardsGTError("GameInformation", "add", "The value cannot conntain a '_' or a '~' in it.");
    m_information[key] = value;
}

QString GameInformation::value(const QString &key) const
{
    map<QString, QString>::const_iterator valueFound = m_information.find(key);

    if (valueFound == m_information.end())
        return "";
    return valueFound->second;
}

void GameInformation::clear()
{
    m_information.clear();
}

ostream& operator<<(ostream &out, const GameInformation &gameInformation)
{
    map<QString, QString>::const_iterator iter = gameInformation.m_information.begin();
    QString key, value;

    while (iter != gameInformation.m_information.end())
    {
        key = iter->first;
        value = iter->second;

        key.replace(" ", "_");
        value.replace(" ", "_");
        out << key << " " << value << " ";
        iter++;
    }
    out << "~";
    return out;
}

QTextStream& operator<<(QTextStream &out, const GameInformation &gameInformation)
{
    map<QString, QString>::const_iterator iter = gameInformation.m_information.begin();
    QString key, value;

    while (iter != gameInformation.m_information.end())
    {
        key = iter->first;
        value = iter->second;

        key.replace(" ", "_");
        value.replace(" ", "_");
        out << key << " " << value << " ";
        iter++;
    }
    out << "~";
    return out;
}

QTextStream& operator>>(QTextStream &in, GameInformation &gameInformation)
{
    gameInformation.clear();
    QString key, value;

    in >> key;
    while (key != "~")
    {
        in >> value;
        key.replace("_", " ");
        value.replace("_", " ");
        gameInformation.add(key, value);
        in >> key;
    }
    return in;
}
