/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

/**
 * The default constructor.
 */
void PlayerSelection::init()
{
    std::vector<QString> players;
    PlayerFactory factory;

    players=factory.playerNames();
    for (int i=0; i < static_cast<int>(players.size()); ++i)
        playersAvailable->insertItem(players[i]);
    playersAvailable->listBox()->sort();
    playersAvailable->setCurrentItem(0);
    currentNumberOfPlayers = 1;
    minimumPlayers = maximumPlayers = 0;
    gameName = "the unknown game";
    displayPlayerInfo();
}

/**
 * This gives the players the user has selected to play with.
 * @return the player's selection.
 */
std::vector<QString> PlayerSelection::selectedPlayers()
{
    std::vector<QString> players;

    for (int i=0, size=playersSelected->count(); i < size; ++i)
        players.push_back(playersSelected->text(i).lower());
    return players;
}

/**
 * Adds a player to the selected list.
 */
void PlayerSelection::addPlayer()
{
    if (playersAvailable->currentText().isEmpty())
        return;

    playersSelected->insertItem(playersAvailable->currentText());
    playersAvailable->removeItem(playersAvailable->currentItem());
    if (playersAvailable->count() > 0)
        playersAvailable->setCurrentItem(0);
    currentNumberOfPlayers++;
    addRemoveStatus();
}

/**
 * Removes a player from the selected list.
 */
void PlayerSelection::removePlayer()
{
    if (playersSelected->currentText().isEmpty())
        return;

    if (currentNumberOfPlayers != 1)
    {
        playersAvailable->insertItem(playersSelected->currentText());
        playersSelected->removeItem(playersSelected->currentItem());
        currentNumberOfPlayers--;
        playersAvailable->listBox()->sort();
        if (playersAvailable->count() > 0)
        {
            playersAvailable->setCurrentItem(0);
            playersAvailable->popup();
            displayPlayerInfo();
        }
        addRemoveStatus();
    }
}

/**
 * This set the boundary conditions for the number of players needed.
 * @param minimum is the minimum number of players needed for the game.
 * @param maximum is the maximum number of players allowed for the game.
 */
void PlayerSelection::setPlayersNeeded(int minimum, int maximum)
{
    minimumPlayers=minimum;
    maximumPlayers=maximum;
    if ((minimumPlayers == maximumPlayers) && (minimumPlayers == 2))
        instructions->setText(QString("Please select %1 player for %2.").arg(minimumPlayers - 1).arg(gameName));
    else if (minimumPlayers == maximumPlayers)
        instructions->setText(QString("Please select %1 players for %2.").arg(minimumPlayers - 1).arg(gameName));
    else
        instructions->setText(QString("Please select %1 to %2 players for %3.").arg(minimumPlayers - 1).arg(maximumPlayers - 1).arg(gameName));
}

/**
 * This enables the start game button if enough players have been selected.
 */
void PlayerSelection::validateNumberOfPlayers()
{
    if (currentNumberOfPlayers < minimumPlayers)
        startGame->setEnabled(false);
    else if (currentNumberOfPlayers > maximumPlayers)
        startGame->setEnabled(false);
    else
        startGame->setEnabled(true);
}

/**
 * This displays the player's image.
 */
void PlayerSelection::displayPlayerInfo()
{
    if (! playersAvailable->currentText().isEmpty())
        playerImage->setPixmap(QImage::fromMimeSource(playersAvailable->currentText().lower() + ".png"));
    else
        playerImage->setPixmap(QImage::fromMimeSource("cardback.png"));
}

/**
 * This gives an explanation on what to do.
 */
void PlayerSelection::help()
{
    QMessageBox::information(this, tr("Player Selection Help"), tr("Select the name of the player you want to play against by clicking on the combobox.\n You can add the player by clicking on the add button. \n You can remove players by selecting the name in the selection box and clicking the remove button. \n Once you have selected enough players, the start game button will activate."));
}

/**
 * This enables/disables the add and remove buttons based on the players availale in each lists.
 */
void PlayerSelection::addRemoveStatus()
{
    if (playersSelected->count() != 0)
        bttnRemovePlayer->setEnabled(true);
    else
        bttnRemovePlayer->setEnabled(false);
    if (playersAvailable->count() != 0)
        bttnAddPlayer->setEnabled(true);
    else
        bttnAddPlayer->setEnabled(false);
}

/**
 * This sets the game we're selecting players for.
 * @param name is the name of the game we're selecting for.
 */
void PlayerSelection::setGameName(const QString &name)
{
    gameName=name;
}
