/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "wally.h"
#include "card.h"
#include "cardsequence.h"
#include "rulebase.h"
// Games Wally knows how to play.
#include "generalgameai.h"
#include "wallycribbageai.h"
#include "wallywarai.h"

#include <qstring.h>

Wally::Wally()
{}

Wally::~Wally()
{}

QString Wally::name() const
{
    return "Wally";
}

CardSequence Wally::whichCards(const QString &game, const CardSequence &playSequence, const RuleBase &rules, const CardSequence &hand) const
{
    CardSequence cards;

    if (game == "cribbage")
    {
        WallyCribbageAI ai(playSequence, rules, hand);
        cards=ai.selectCards();
    }
    else if (game == "cribbageDealerCrib")
    {
        WallyCribbageAI ai(playSequence, rules, hand);
        cards=ai.selectDealersCribCards();
    }
    else if (game == "cribbageNonDealerCrib")
    {
        WallyCribbageAI ai(playSequence, rules, hand);
        cards=ai.selectNonDealersCribCards();
    }
    else if (game == "heartsPassPhase")
    {
        GeneralGameAI ai(playSequence, rules, hand);
        cards=ai.randomCardsWithNoLegalChecks(3);
    }
    else if (game == "war")
    {
        WallyWarAI ai(hand);
        cards=ai.selectCards();
    }
    else
    {
        GeneralGameAI ai(playSequence, rules, hand);
        cards=ai.selectCards(1);
    }
    return cards;
}

Player::skill_Level Wally::skillLevel(const QString &game) const
{
    if (game == "cribbage")
        return Player::Apprentice;
    else if (game == "war")
        return Player::Master;
    else
        return Player::Newb;
}
