/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "norman.h"
#include "generalgameai.h"
// The games Norman knows how to play
#include "normanheartsai.h"

Norman::Norman(): AIBase()
{}

Norman::~Norman()
{}

CardSequence Norman::whichCards(const QString& game, const CardSequence& playSequence, const RuleBase& rules, const CardSequence& hand) const
{
    CardSequence cards;

    if (game == "cribbage")
    {
        GeneralGameAI ai(playSequence, rules, hand);
        cards=ai.selectCards(1);
    }
    else if (game == "cribbageDealerCrib")
    {
        GeneralGameAI ai(playSequence, rules, hand);
        cards=ai.randomCardsWithNoLegalChecks(2);
    }
    else if (game == "cribbageNonDealerCrib")
    {
        GeneralGameAI ai(playSequence, rules, hand);
        cards=ai.randomCardsWithNoLegalChecks(2);
    }
    else if (game == "hearts")
    {
        NormanHeartsAI ai(playSequence, rules, hand);
        cards=ai.selectCards();
    }
    else if (game == "heartsPassPhase")
    {
        NormanHeartsAI ai(playSequence, rules, hand);
        cards=ai.passCards();
    }
    else
    {
        GeneralGameAI ai(playSequence, rules, hand);
        cards=ai.selectCards(1);
    }
    return cards;
}

Player::skill_Level Norman::skillLevel(const QString& game) const
{
    if (game == "hearts")
        return Player::Professional;
    else
        return Player::Newb;
}

QString Norman::name() const
{
    return "Norman";
}
