/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef KARDSGTINTERFACE_H
#define KARDSGTINTERFACE_H

#include "kardsgtinterfacebase.h"
#include "player.h"
#include "userprofiledatabase.h"

class GameFactory;

/**
 * This is the main interface for the KardsGT card game.
 *
 * @author John Schneiderman
 */
class KardsGTInterface: public KardsGTInterfaceBase
{
    Q_OBJECT

public:
    /**
     * This is the default widget constructor.
     * @param path is the path to the KardsGT user database profile.
     * @param parent is the parent of the widget.
     * @param name is the name of this widget.
     * @param fileName is the name of the game file we want to load.
     */
    KardsGTInterface(QString path, QWidget *parent=0, const char *name=0, QString fileName="");
    /**
     * This is the default widget destructor.
     */
    virtual ~KardsGTInterface();

protected slots:
    /**
     * Is the slot for when we set up a card game.
     * @throw KardsGTError if we fail to create the game.
     */
    virtual void setupGame();

protected:
    /**
     * This retrieves and decodes a player's game skill level.
     * @param game is the name of the game to retrieve.
     * @return the skill level for that player at that game.
     */
    Player::skill_Level playersLevel(const QString &game) const;

private:
    /// @param m_userProfileDB is the user game profile database.
    UserProfileDatabase m_userProfileDB;

    /**
     * Creates the AI Opponents in the opponent list.
     * @throw KardsGTError if we cannot create an opponent.
     */
    void createOpponents();
};
#endif
