/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "cribbagepeg.h"

#include <qpainter.h>

CribbagePeg::CribbagePeg(const QColor &colour, const QPoint &position, bool leadPeg, QWidget *parent, const char *name):QWidget(parent, name, WPaintClever | WRepaintNoErase)
{
    m_score=0;
    m_colour=colour;
    m_lead=m_startLead=leadPeg;
    m_positionX=m_startX=position.x();
    m_positionY=m_startY=position.y();
}

int CribbagePeg::x() const
{
    return m_positionX;
}

int CribbagePeg::y() const
{
    return m_positionY;
}

QPoint CribbagePeg::position() const
{
    return QPoint(m_positionX, m_positionY);
}

void CribbagePeg::setPosition(int x, int y)
{
    m_positionX=x;
    m_positionY=y;
}

void CribbagePeg::setPosition(const QPoint &point)
{
    m_positionX=point.x();
    m_positionY=point.y();
}

int CribbagePeg::score() const
{
    return m_score;
}

void CribbagePeg::setScore(int score)
{
    m_score=score;
}

void CribbagePeg::draw(QPainter *painter)
{
    QBrush brush=painter->brush();
    QPen pen=painter->pen();

    painter->setBrush(QBrush(m_colour));
    painter->drawEllipse(m_positionX, m_positionY, 2, 2);
    painter->drawEllipse(m_positionX - 1, m_positionY - 2, 2, 2);
    painter->setPen(QPen(m_colour, 4, SolidLine));
    painter->drawLine(m_positionX + 1, m_positionY + 1, m_positionX - 1, m_positionY - 2);
    painter->setBrush(brush);
    painter->setPen(pen);
}

const QColor& CribbagePeg::colour() const
{
    return m_colour;
}

bool CribbagePeg::isFront() const
{
    return m_lead;
}

void CribbagePeg::setLead(bool lead)
{
    m_lead=lead;
}

void CribbagePeg::reset()
{
    m_lead=m_startLead;
    setPosition(m_startX, m_startY);
    setScore(0);
}
