/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "gamefactory.h"
#include "kardsgterror.h"
// Games we know how to launch
#include "cribbageinterface.h"
#include "warinterface.h"
#include "heartsinterface.h"

#include <qstring.h>
#include <qwidgetstack.h>


GameFactory::GameFactory()
{
    m_pGame=0;
}

GameFactory::~GameFactory()
{
    if (m_pGame != 0)
        delete m_pGame;
}

const GameBase& GameFactory::game() const
{
    if (m_pGame == 0)
        throw KardsGTError("GameFactory", "game const", "m_pGame has not be set!");
    else
        return *m_pGame;
}

GameBase& GameFactory::game()
{
    if (m_pGame == 0)
        throw KardsGTError("GameFactory", "game", "m_pGame has not be set!");
    else
        return *m_pGame;
}

bool GameFactory::createGame(UserProfileDatabase &profileDatabase, const QString &game, QWidgetStack &layout)
{
    if (m_pGame != 0)
        return false;
    if (setupGame(profileDatabase, game, layout))
        return true;
    else
        return false;
}

void GameFactory::clear()
{
    if (m_pGame != 0)
    {
        delete m_pGame;
        m_pGame = 0;
    }
}

bool GameFactory::hasGame() const
{
    if (m_pGame != 0)
        return true;
    else
        return false;
}

bool GameFactory::setupGame(UserProfileDatabase &profileDatabase, const QString &game, QWidgetStack &layout)
{
    if (game == "cribbage")
        m_pGame = new CribbageInterface(profileDatabase, &layout, "cribbage interface");
    else if (game == "war")
        m_pGame = new WarInterface(profileDatabase, &layout, "war interface");
    else if (game == "hearts")
        m_pGame = new HeartsInterface(profileDatabase, &layout, "hearts interface");
    else
        return false;
    layout.addWidget(dynamic_cast<QWidget *>(m_pGame), 1);
    return true;
}
