/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef KARDSELECTION_H
#define KARDSELECTION_H

#include "kardsequence.h"

#include <qdialog.h>

class QString;
class QPushButton;
class CardSequence;

/**
 * This is a dialogue that presents a user with a sequence of cards and requests that they choose a specific number of them.
 *
 * @author John Schneiderman
 */
class KardSelection: public QDialog
{
    Q_OBJECT

public:
    /**
     * Creates a dialogue to select a specific number of presented cards.
     * @param caption is the caption to display for the user, usually explaining what they need to do.
     * @param number is how many cards the user must select.
     * @param choices are the cards that a user can choose from.
     * @param parent is the parent of the dialogue.
     * @param name is the name of this dialogue.
     * @param modal determines if the dialogue should be modal or not.
     * @note The dialogue will not be able to exit with an accept status until the user has selected exactly the number of cards requested.
     */
    KardSelection(const QString &caption, int number, const CardSequence &choices, QWidget *parent=0, const char *name=0, bool modal=true);
    /**
     * Widget destructor.
     */
    ~KardSelection();
    /**
     * Gives the selection that the user has made.
     * @return the selection from the user.
     * @throw KardsGTError if a selection has not been made by a user.
     */
    const CardSequence& selection() const;

private:
    /// @param m_numberToChoose is how many cards the user must choose.
    int m_numberToChoose;
    /// @param m_pSelectButton is button to push once the selection has been made.
    QPushButton *m_pSelectButton;
    /// @param m_pKardsSelected is the card images of the cards the user has selected.
    KardSequence *m_pKardsSelected;
    /// @param m_pKardsSelection is the card images of the cards the user can select.
    KardSequence *m_pKardsSelection;

private slots:
    /**
     * This is a slot to determine if the selection button should be enabled or disabled.
     */
    void enableButton();
};
#endif
