/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "kardselection.h"
#include "cardsequence.h"
#include "kard.h"
#include "kardsgterror.h"

#include <qstring.h>
#include <qlayout.h>
#include <qpushbutton.h>

KardSelection::KardSelection(const QString &caption, int number, const CardSequence &choices, QWidget *parent, const char *name, bool modal):QDialog(parent, name, modal, WPaintClever | WRepaintNoErase)
{
    setMaximumSize(parent->width(), parent->height());
    QVBoxLayout *mainLayout=new QVBoxLayout(this, 11, 6, "KardSelection mainLayout");
    QHBoxLayout *selectedLayout=new QHBoxLayout(0, 11, 6, "KardSelection selectedLayout"); // A widget can only use one layout at a time.

    m_numberToChoose=number;
    setCaption(caption);

    // Set up the selected sequences
    m_pKardsSelected = new KardSequence(this, "KardSelection m_pKardsSelected");
    m_pKardsSelected->setFaceUp(true);
    m_pKardsSelected->setMinimumSize(Kard::PREFERRED_WIDTH * m_numberToChoose, Kard::PREFERRED_HEIGHT);

    // Setup the selection sequences
    m_pKardsSelection = new KardSequence(this, "KardSelection m_pKardSelection");
    m_pKardsSelection->setFaceUp(true);
    m_pKardsSelection->setCardSequence(choices);

    // Setup the OK button
    m_pSelectButton = new QPushButton(this, "KardSelection m_pSelectButton");
    m_pSelectButton->setText("Okay");
    m_pSelectButton->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    m_pSelectButton->setEnabled(false);

    // Setup widgets
    connect(m_pKardsSelection, SIGNAL(kardSelected(Kard &)), m_pKardsSelected, SLOT(addKard(Kard &)));
    connect(m_pKardsSelection, SIGNAL(kardSelected(Kard &)), m_pKardsSelection, SLOT(removeKard(Kard &)));
    connect(m_pKardsSelection, SIGNAL(kardSelected(Kard &)), this, SLOT(enableButton()));
    connect(m_pKardsSelected, SIGNAL(kardSelected(Kard &)), m_pKardsSelection, SLOT(addKard(Kard &)));
    connect(m_pKardsSelected, SIGNAL(kardSelected(Kard &)), m_pKardsSelected, SLOT(removeKard(Kard &)));
    connect(m_pKardsSelected, SIGNAL(kardSelected(Kard &)), this, SLOT(enableButton()));
    connect(m_pSelectButton, SIGNAL(clicked()), this, SLOT(accept()));
    selectedLayout->addWidget(m_pKardsSelected);
    selectedLayout->addWidget(m_pSelectButton);
    mainLayout->addWidget(m_pKardsSelection);
    mainLayout->addLayout(selectedLayout);
}

KardSelection::~KardSelection()
{
    delete m_pKardsSelection;
    delete m_pKardsSelected;
    delete m_pSelectButton;
}

const CardSequence& KardSelection::selection() const
{
    if (m_pKardsSelected != NULL)
        return m_pKardsSelected->cardSequence();
    else
        throw KardsGTError("KardSelection", "selection", "m_pKardsSelected is NULL!");
}

void KardSelection::enableButton()
{
    if (m_pKardsSelected->size() == m_numberToChoose)
        m_pSelectButton->setEnabled(true);
    else
        m_pSelectButton->setEnabled(false);
}
