/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "karddisplay.h"
#include "kard.h"
#include "kardsgterror.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>

KardDisplay::KardDisplay(const QString &caption, const vector<CardSequence> &hands, const vector<QString> &messages, QWidget *parent, const char *name, bool modal):QDialog(parent, name, modal, WPaintClever | WRepaintNoErase)
{
    setMaximumSize(parent->width(), parent->height());
    setCaption(caption);
    Kard *kard;

    if (hands.size() != messages.size())
        throw KardsGTError("Kardm_display", "Kardm_display", "hands is not the same size as messages!");
    m_hands=hands;
    m_messages=messages;
    for (int i=0; i < static_cast<int>(m_hands.size()); ++i)
    {
        m_messageLayouts.push_back(new QHBoxLayout());

        // Create a Kard from the sequence
        for (int j=0; j < m_hands[i].size(); ++j)
        {
            kard=new Kard(this, "Kardm_displayKard");
            kard->setCard(m_hands[i][j]);
            kard->flipCard();
            m_messageLayouts[i]->addWidget(kard);
        }

        // Create a qlabel to m_display the message
        QLabel *qlabel;
        qlabel=new QLabel(this);
        qlabel->setText(m_messages[i]);
        m_messageLayouts[i]->addWidget(qlabel);
    }

    //Create selecting button.
    m_bttnOkay=new QPushButton(this, "m_bttnOkay");
    m_bttnOkay->setText(tr("Okay"));
    m_bttnOkay->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    // Create the layout of the dialogue
    m_display=new QVBoxLayout(this);
    m_display->setMargin(11);
    m_display->setSpacing(6);
    for (int i=0; i < static_cast<int>(m_messageLayouts.size()); ++i)
        m_display->addLayout(m_messageLayouts[i]);
    m_display->addWidget(m_bttnOkay);
    connect(m_bttnOkay, SIGNAL(clicked()), this, SLOT(accept()));
}

KardDisplay::~KardDisplay()
{
    if (m_display != NULL)
        delete m_display;
    if (m_bttnOkay != NULL)
        delete m_bttnOkay;
}
