/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "player.h"
#include "card.h"
#include "kardsgterror.h"

#include <qtextstream.h>

Player::Player():m_hand()
{
    m_name="Not Known";
    m_gameScore=m_roundScore=0;
    m_level=Skill_Error;
    m_dealer=m_turn=false;
}

Player::~Player()
{}

QString Player::name() const
{
    return m_name;
}

void Player::setName(const QString &name)
{
    m_name=name;
}

const CardSequence& Player::hand() const
{
    return m_hand;
}

CardSequence& Player::hand()
{
    return m_hand;
}

int Player::score() const
{
    return m_roundScore;
}

void Player::addPoint(int point)
{
    m_roundScore += point;
}

void Player::removePoint(int point)
{
    m_roundScore -= point;
}

bool Player::isDealer() const
{
    return m_dealer;
}

void Player::setDealer(bool m_dealer)
{
    this->m_dealer=m_dealer;
}

void Player::incrementGamesWon()
{
    m_gameScore++;
}

void Player::decrementGamesWon()
{
    m_gameScore--;
}

int Player::gamesWon() const
{
    return m_gameScore;
}

bool Player::isTurn() const
{
    return m_turn;
}

void Player::setTurn(bool turn)
{
    m_turn=turn;
}

Player::skill_Level Player::level() const
{
    return m_level;
}

void Player::setLevel(Player::skill_Level level)
{
    m_level=level;
}

bool Player::operator==(const Player &player) const
{
    if (m_name == player.name())
        if (m_hand == player.hand())
            return true;
        else
            return false;
    else
        return false;
}

void Player::reset()
{
    m_dealer=false;
    m_turn=false;
    m_hand.clear();
}

void Player::resetRoundScore()
{
    m_roundScore=0;
}

void Player::clear()
{
    reset();
    resetRoundScore();
    m_gameScore=0;
}

QTextStream& operator<<(QTextStream &out, const Player &player)
{
    QString name;

    name = player.m_name;
    name.replace(" ", ":");
    out << "Name: " << name << endl;
    out << "Hand: " << player.m_hand << endl;
    out << "Score: " << player.m_roundScore << endl;
    out << "GamesWon: " << player.m_gameScore << endl;
    out << "Dealer: " << player.m_dealer << endl;
    out << "Turn: " << player.m_turn << endl;
    out << "Level: " << player.m_level;
    return out;
}

ostream& operator<<(ostream &out, const Player &player)
{
    QString name;

    name = player.m_name;
    name.replace(" ", ":");
    out << "Name: " << name << endl;
    out << "Hand: " << player.m_hand << endl;
    out << "Score: " << player.m_roundScore << endl;
    out << "GamesWon: " << player.m_gameScore << endl;
    out << "Dealer: " << player.m_dealer << endl;
    out << "Turn: " << player.m_turn << endl;
    out << "Level: " << player.m_level;
    return out;
}

QTextStream& operator>>(QTextStream &in, Player &player)
{
    int intToBool;
    QString label;

    in >> label >> player.m_name;
    player.m_name = player.m_name.replace(":", " ");
    in >> label >> player.m_hand;
    in >> label >> player.m_roundScore;
    in >> label >> player.m_gameScore;
    in >> label >> intToBool;
    player.m_dealer=static_cast<bool>(intToBool);
    in >> label >> intToBool;
    player.m_turn=static_cast<bool>(intToBool);
    in >> label >> intToBool;
    player.m_level=static_cast<Player::skill_Level>(intToBool);
    return in;
}
