#!/usr/bin/env python
#******************************************************************************
#**** Copyright (C) 2009, 2010                                             ****
#****   John Schneiderman <JohnMS@member.fsf.org>                          ****
#****                                                                      ****
#**** This program is free software: you can redistribute it and/or modify ****
#**** it under the terms of the GNU General Public License as published by ****
#**** the Free Software Foundation, either version 3 of the License, or    ****
#**** (at your option) any later version.                                  ****
#****                                                                      ****
#**** This program is distributed in the hope that it will be useful,      ****
#**** but WITHOUT ANY WARRANTY; without even the implied warranty of       ****
#**** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        ****
#**** GNU General Public License for more details.                         ****
#****                                                                      ****
#**** You should have received a copy of the GNU General Public License    ****
#**** along with this program.  If not, see <http://www.gnu.org/licenses/> ****
#******************************************************************************

"""
 IMPORTS
"""
import wx

import mediasongdataobject as dataObject


class MediaSongDropTarget(wx.PyDropTarget):
    """ Connector to support drag-and-drop for a MediaSong object. """

    """
     ATTRIBUTES
    """
    # Call-back function used to insert the MediaSong objects into drop target.
    insertFunction = None
    # Pickled songs
    data = None


    def __init__(self, insertFunction):
        """ Default constructor

         Prepares temporary storage of the MediaSongs for dropping on a target.
         string insertFunction: name of the function used to call-back for
           inserted the dragged MediaSong objects.
        """
        wx.PyDropTarget.__init__(self)
        #print "MediaSongDropTarget.__init__(self, insertFunction)", self, insertFunction
        self.insertFunction = insertFunction
        self.data = dataObject.MediaSongDataObject()
        self.SetDataObject(self.data)

    def OnData(self, x, y, drag_result):
        """ Initiates the drop operation.

         The call-back function is called passing along the coordinates,
           pickled data, and type of drag operation.
         int x: horizontal coordinate at the moment of drop.
         int y: vertical coordinate at the moment of drop.
         wx.ID drag_result: is the type of drop operation.
         return wx.ID:type of drop operation to perform.
        """
        #print "MediaSongDropTarget.OnData(self, x, y)", self, x, y
        if self.GetData():
            self.insertFunction(x, y, self.data.songs, drag_result)
        return drag_result
