#!/usr/bin/env python
# -*- coding: utf-8 -*-
#******************************************************************************
#**** Copyright (C) 2009, 2010                                             ****
#****   John Schneiderman <JohnMS@member.fsf.org>                          ****
#****                                                                      ****
#**** This program is free software: you can redistribute it and/or modify ****
#**** it under the terms of the GNU General Public License as published by ****
#**** the Free Software Foundation, either version 3 of the License, or    ****
#**** (at your option) any later version.                                  ****
#****                                                                      ****
#**** This program is distributed in the hope that it will be useful,      ****
#**** but WITHOUT ANY WARRANTY; without even the implied warranty of       ****
#**** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        ****
#**** GNU General Public License for more details.                         ****
#****                                                                      ****
#**** You should have received a copy of the GNU General Public License    ****
#**** along with this program.  If not, see <http://www.gnu.org/licenses/> ****
#******************************************************************************

"""
 IMPORTS
"""
import mediasongwindow as SongWindow

import wx


class FavouriteWindow(wx.Panel):
    """ Interface display of favourite songs in the media library. """

    """
     ATTRIBUTES
    """
    # A function pointer to the media library search
    __mediaSeach = None
    # A function pointer to the media library search finished
    __searchFinished = None
    # A function pointer to the media library search results
    __foundSongs = None

    """
     EVENT ID
    """
    # Identifier for the song display.
    ID_FAVOURITE_RESULTS = wx.NewId() # Display for the songs of a Favourite

    def __init__(self, parent, iconPath, searchFunction, searchDoneFunction, \
            searchResultsFunction):
        """ Default constructor

         wx.Window parent: is the parent window.
        """
        wx.Panel.__init__(self, parent, wx.NewId())
        self.__mediaSeach = searchFunction
        self.__searchFinished = searchDoneFunction
        self.__foundSongs = searchResultsFunction
        self.__createControls(iconPath)
        self.__bindEvents()
        self.__doLayout()

    def __createControls(self, iconPath):
        """ Create the controls for the Favourite window.
        """
        self.__sttcTxtName = wx.StaticText(self, wx.ID_ANY, \
            "Favourite Songs", style=wx.ALIGN_CENTRE)

        # Create Favourite Song Displays
        self.__favouritesDisplay = SongWindow.MediaSongWindow(self, iconPath, \
            self.ID_FAVOURITE_RESULTS)

    def __bindEvents(self):
        """ Connects all the needed events.

         Connects each of the control objects created to their corresponding
           methods.
        """
        pass

    def __doLayout(self):
        """ Creates a visually pleasing look for the controls.

         All the control objects are placed on the window.
        """
        # Favourite Songs Layout
        self.__bxSzrFavouriteSongs = wx.BoxSizer(wx.VERTICAL)
        self.__bxSzrFavouriteSongs.Add(self.__sttcTxtName, 0, wx.EXPAND | \
            wx.ALL, 3)
        self.__bxSzrFavouriteSongs.Add(self.__favouritesDisplay, 1, \
            wx.EXPAND | wx.ALL, 3)

        # Create Interface
        self.__bxSzrInterface = wx.BoxSizer(wx.VERTICAL)
        self.__bxSzrInterface.Add(self.__bxSzrFavouriteSongs, 1, wx.EXPAND | \
            wx.ALL)
        self.SetSizer(self.__bxSzrInterface)
        self.updateDisplay()

    def addPopUpMenuItem(self, idPopUp, action):
        self.__mnItmPopUp = wx.MenuItem( \
            self.__favouritesDisplay.mnDisplayWindowPopup, idPopUp, action)
        self.__favouritesDisplay.mnDisplayWindowPopup.AppendItem( \
            self.__mnItmPopUp)

    def selectedSongs(self):
        """ Accessor to the currently selected songs

         return list[MediaSong]: each of the songs selected by the user.
        """
        return self.__favouritesDisplay.displayedSongs()

    def updateDisplay(self):
        self.__mediaSeach(None, True, True, True)
        while self.__searchFinished() is False:
            pass

        self.__favouritesDisplay.clearDisplayedSongs()
        songsFound = self.__foundSongs()
        if songsFound is not None:
            for song in songsFound:
                self.__favouritesDisplay.addDisplayedSong(song)
