#!/usr/bin/env python
#******************************************************************************
#**** Copyright (C) 2009, 2010                                             ****
#****   John Schneiderman <JohnMS@member.fsf.org>                          ****
#****                                                                      ****
#**** This program is free software: you can redistribute it and/or modify ****
#**** it under the terms of the GNU General Public License as published by ****
#**** the Free Software Foundation, either version 3 of the License, or    ****
#**** (at your option) any later version.                                  ****
#****                                                                      ****
#**** This program is distributed in the hope that it will be useful,      ****
#**** but WITHOUT ANY WARRANTY; without even the implied warranty of       ****
#**** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        ****
#**** GNU General Public License for more details.                         ****
#****                                                                      ****
#**** You should have received a copy of the GNU General Public License    ****
#**** along with this program.  If not, see <http://www.gnu.org/licenses/> ****
#******************************************************************************

class PlayerBase():
    """ Abstract interface for media players. """

    def __init__(self, playerName="No Media Player Found"):
        print "Starting player %s" % playerName

    def quitRunning(self):
        """ Signal the media player to quit running. """
        print "PlayerBase.quitRunning(self)"
        pass

    def isSongEnded(self):
        """ Determines if a song has ended.

         return boolean: true if the song has finished, false else-wise
        """
        print "PlayerBase.isSongEnded(self)"
        pass

    def playSong(self, song, volume):
        """ Starts to play a song.

         Hands the song to play off to the media player.
         MediaSong song: is the song to play.
         int volume: is the volume percentage level.
         return boolean: true if the signal to play succeeds, false
           if one of the pre-conditions for starting to play is not met at the
           time of sending the signal.
        """
        print "PlayerBase.playSong(self, song, volume)", song, volume
        pass

    def isRunning(self):
        """ Determines if the media player is running.

         return boolean: true if the player is running, false else-wise
        """
        print "PlayerBase.isRunning(self)"
        pass

    def isStarting(self):
        """ Determines if the player is in the process of starting up.

         return boolean: true if the player is starting up, false else-wise
        """
        print "PlayerBase.isStarting(self)"
        pass

    def isPlaying(self):
        """ Indicates if the player is playing a song.

         return boolean: true if a song is playing, false else-wise
        """
        print "PlayerBase.isPlaying(self)"
        pass

    def isPaused(self):
        """ Indicates if the player is paused

         return boolean: true if a song is paused, false else-wise
        """
        print "PlayerBase.isPaused(self)"
        pass

    def stopSong(self):
        """ Signal to stop the currently playing song. """
        print "PlayerBase.stopSong(self)"
        pass

    def pauseSong(self):
        """ Signal to pause the currently playing song. """
        print "PlayerBase.pauseSong(self)"
        pass

    def unpauseSong(self):
        """ Signal to un-pause the currently playing song. """
        print "PlayerBase.unpauseSong(self)"
        pass

    def setVolumeLevel(self, volumeLevel):
        """ Signal to set the volume level of the media player.

         Signal to change the volume level of the media player.
         int volumeLevel: is the percentage level to set the volume at.
         return boolean: True if the signal is successfully sent, false
           if one of the pre-conditions for setting the volume level is not
           met at the time of sending the signal.
        """
        print "PlayerBase.setVolumeLevel(self, volumeLevel)", volumeLevel
        pass

    def volumeLevel(self):
        """ Current volume level of the media player.
         return int: the percentage level of volume of the media player.
        """
        print "PlayerBase.volumeLevel(self)"
        pass

    def setPlayPosition(self, seconds):
        """ Signal to change the position of the currently playing song.

         float seconds: is the position in the song to play from in terms of
           the number of seconds starting from the beginning of the song.
         return boolean: True if the signal is successfully sent, false
           if one of the pre-conditions for setting the position is not met at
           the time of sending the the signal.
        """
        print "PlayerBase.setPlayPosition(self, seconds)", seconds
        pass

    def positionInSong(self):
        """ Accessor to the current position in a song.

         return float: the total seconds that have passed in the currently
           playing song.
        """
        print "PlayerBase.positionInSong(self)"
        pass

    def totalSongTime(self):
        """ Accessor to the total time in a song.

         return float: the total number of seconds in the current song.
        """
        print "PlayerBase.totalSongTime(self)"
        pass
