#!/usr/bin/env python
#******************************************************************************
#**** Copyright (C) 2009  John Schneiderman <JohnMS@member.fsf.org>        ****
#****                                                                      ****
#**** This program is free software: you can redistribute it and/or modify ****
#**** it under the terms of the GNU General Public License as published by ****
#**** the Free Software Foundation, either version 3 of the License, or    ****
#**** (at your option) any later version.                                  ****
#****                                                                      ****
#**** This program is distributed in the hope that it will be useful,      ****
#**** but WITHOUT ANY WARRANTY; without even the implied warranty of       ****
#**** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        ****
#**** GNU General Public License for more details.                         ****
#****                                                                      ****
#**** You should have received a copy of the GNU General Public License    ****
#**** along with this program.  If not, see <http://www.gnu.org/licenses/> ****
#******************************************************************************

from distutils.core import setup


# Basic package setup information
setup(  name='kap',
        version='0.4.0',
        description='A player with a search-able media library',
        long_description='Karaoke Audio-video Player is a media player with for KJs at their shows.',
        author='John Schneiderman',
        author_email='JohnMS@member.fsf.org',
        url='http://kap.nongnu.org',
        license='GPLv3+',
        platforms=  [
                        'GNU/Linux',
                        'POSIX',
                        'Mac OS',
                        'Windows'
                    ],
        classifiers=[
                        'Development Status :: 3 - Alpha',
                        'Environment :: MacOS X',
                        'Environment :: Win32 (MS Windows)',
                        'Environment :: X11 Applications :: GTK',
                        'Intended Audience :: End Users/Desktop',
                        'License :: OSI Approved :: GNU General Public License (GPL)',
                        'Natural Language :: English',
                        'Operating System :: MacOS',
                        'Operating System :: Microsoft :: Windows',
                        'Operating System :: POSIX :: Linux',
                        'Programming Language :: Python :: 2.5',
                        'Topic :: Multimedia :: Sound/Audio :: Players'
                    ],
        data_files= [
                         (
                              'bin',    [
                                             'data/kap'
                                        ]
                         ),
                         (    'share/applications',    [
                                                            'data/kap.desktop'
                                                       ]
                         )
                    ],
        packages=['kap']
     )