# With jugtail you can assist veronica in harvesting its
# data by placing this file in your gopher tree such that the gopher
# pathway is one of the following:
#            0/veronica.ctl
#            0/etc/veronica.ctl
#            0/robots.txt
#
# You will also want to edit gopherd.conf and add the
# appropriate gopher configuration command which will prevent this
# file from being seen, and needs to be one of the following:
#            ignore: veronica.ctl
#            ignore: etc
#            ignore: robots.txt
#
# The veronica servers prefer you exclude local information such as:
# course schedules, USENET files, etc.
#
# If you don't want to make your entire jugtail database available to
# veronica due to data you don't want the world to have access to, have
# jugtail create a database with the -b flag that only traverses the parts
# of your gopher server you want to have world access.  You can do this
# using either the -x or -X flags to restrict what jugtail traverses.
# Now move the database you created into your gopher tree, probably in
# etc at the root of your gopher server, and alter the "veronica-datafile:"
# line to be something like:
# veronica-datafile: gopher://GOPHER.SERVER.HOST:GOPHER-PORT/00/0/etc/DATA
# Where GOPHER.SERVER.HOST is the name of your gopher server, GOPHER-PORT
# is the port your gopher server is using, which is probably port 70, and
# DATA is the database jugtail created for worldwide distribution via
# veronica.
#
#------------------ veronica.ctl file ---------------------------------------
#  comment line, optional

#  blank line above this one demarks beginning of veronica control block
#  There must be NO BLANK LINES WITHIN the following set of veronica control
#      lines.  Comment lines are OK in the veronica control block.
#
#  User-agent line is REQUIRED
User-agent: veronica
#
#  veronicaindex:  line is SUGGGESTED. Normally it should be
#  "veronicaindex: yes".  Set it  to "veronicaindex: no" only if you 
#  want to COMPLETELY turn off the veronica indexing for this 
#  gopher server.
#  If veronicaindex line is absent, default will be "yes". 
veronicaindex: yes
#
#  veronica-datafile  line specifies URL for veronica to use in retrieving
#     pre-built data file.  OPTIONAL and suggested.
#     Example for use with jugtail 1.0.3 and above:
veronica-datafile: gopher://jugtail.server.host:jugtail-port/0?datafile
#     NOTE that only one veronica-datafile line is allowed.
#
#  veronica-datafile-prep line specifies degree of veronica-specific 
#     pre-processing that has been done to the veronica-datafile.
#     For jugtail-prepared files ( jugtail 1.0.3 ), set
#     veronica-datafile-prep: raw
#     For jugtail-prepared files ( jugtail 1.0.4 ), set
#     veronica-datafile-prep: disallow-lines
#     This line is OPTIONAL and suggested.
veronica-datafile-prep: disallow-lines
#
#  "Disallow" line is for compatibility with the no-robots standard format.
#  At least one "Disallow:" statement is required, even if it is an empty
#  specifier.
#  You may include disallow lines specifying gopher paths which veronica
#  should avoid.  More documentation on this will be available via gopher
#  at veronica.scs.unr.edu, no later than September 4, 1994.
#  Example of a Disallow line:
#    "Disallow: 1/Campus/Course_Schedules_Fall_94"
#  That example tells veronica not to index that directory, its contents
#  and subdirectories, recursively.
#  Disallow lines must specify gopher Type 1 items, not type 0 or others.
#  Here is the required Disallow line:
Disallow: 

#  blank line marked end of veronica control block.
#------------------------------------------------------------------------ 
