/*
  path.c, written by Rhett "Jonzy" Jones 

  Jonzy's Universal Gopher Hierarchy Excavation And Display.
  Excavates through gopher menus and displays the hierarchy
  of the menus encountered

  Copyright (C) 1993, 1994 University of Utah Computer Center.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program (look for the file called COPYING);
  if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*
 * Description:	Routines used to print the current path to a given
 *		gopher menu item.  These routines use a stack
 *		implemented with a doubly linked list
 */

#include "stdinc.h"

int PopPath (void);
int PrintPath (void);
int PushPath (char *dStr, char *sStr, char *hStr, char *pStr);

typedef struct PN
{
  char *str;			/* The string of concern. */
  struct PN *next,		/* Pointer to the next item. */
   *last;			/* Pointer to the previous item. */
} PType;

static PType *head = NULL,	/* Bottom of the stack. */
  *tail = NULL;			/* Top of the stack. */

extern FILE *rptPtr;		/* Defined in "jugtailConf.c". */

/*****************************************************************************
 * PopPath returns true is the top of stack could be popped and
 * false otherwise.
 ****************************************************************************/
int
PopPath (void)
{
  PType *tmp;			/* Temporary node. */

  if (tail)
    {
      tmp = tail->last;
      tmp->next = NULL;
      free (tail->str);
      free (tail);
      tail = tmp;
      return (1);
    }
  return (0);

}				/* PopPath */

/*****************************************************************************
 * PrintPath returns the number of items in the stack and prints the
 * stack contents indented such that the top of stack gets indented
 * the most.  If there is not stack this routine return 0.
 ****************************************************************************/
int
PrintPath (void)
{
  PType *tmp;			/* Temporary node. */
  int i, j;			/* Loop counters. */

  if (head)
    {
      for (i = 0, tmp = head; tmp; i++, tmp = tmp->next)
	{
	  for (j = 0; j < i; j++)
	    fprintf (rptPtr, "    ");
	  fprintf (rptPtr, "%s\n", tmp->str);
	}
      return (i);
    }
  return (0);

}				/* PrintPath */

/*****************************************************************************
 * PushPath returns true if we were able to push the strings on the stack
 * and false otherwise.  When pushing the stack we create a string which
 * has the following format:
 *
 *        "dStr | {[sStr] hStr pStr}"
 *
 * Where " | " represents the tab character.
 ****************************************************************************/
int
PushPath (char *dStr, char *sStr, char *hStr, char *pStr)
     /* dStr: The display string.
        sStr: The selector string.
	hStr: The host string.
	pStr: The port string.      */
{
  PType *tmp;			/* Temporary node. */
  unsigned numChars;		/* Size of the string to create. */

  if ((tmp = malloc (sizeof (PType))))
    {
      numChars = strlen (dStr) + strlen (sStr) +
	strlen (hStr) + strlen (pStr) + 8;
      if ((tmp->str = malloc (numChars)))
	{

	  /* Create the string for the stack. */
	  strcpy (tmp->str, dStr);
	  strcat (tmp->str, "\t{[");
	  strcat (tmp->str, sStr);
	  strcat (tmp->str, "] ");
	  strcat (tmp->str, hStr);
	  strcat (tmp->str, " ");
	  strcat (tmp->str, pStr);
	  strcat (tmp->str, "}");

	  /* Set the stack pointers somewhere meaningful. */
	  tmp->next = tmp->last = NULL;

	  if (!head)
	    head = tail = tmp;
	  else
	    {
	      tail->next = tmp;
	      tmp->last = tail;
	      tail = tmp;
	    }
	  return (1);
	}
    }
  return (0);

}				/* PushPath */
