/*
    dirTree.h, written by Rhett "Jonzy" Jones 

    Jonzy's Universal Gopher Hierarchy Excavation And Display.
    Excavates through gopher menus and displays the hierarchy
    of the menus encountered

    Copyright (C) 1993, 1994 University of Utah Computer Center.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program (look for the file called COPYING);
    if not, write to the Free Software Foundation, Inc.,
        51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	                                                                 */
#ifndef DIRTREE_H
#define DIRTREE_H

#define DSTR	0
#define PSTR	1
#define HSTR	2
#define SSTR	3
#define STRS	4

typedef struct dirNode
{
  long lineNum;
  char *str;
  struct dirNode *left, *right, *tree;
} DirTreeType;
extern DirTreeType *dirRoot;

extern void PrintDirTree (DirTreeType *dTree, short whichStr);
extern long InDirTree (DirTreeType *dTree, short whichStr);
extern DirTreeType *WhatDirBranch (DirTreeType *dTree, short whichStr);
extern DirTreeType *BuildDirTree (DirTreeType *dTree);
extern void WaterTree (char *sStr, char *hStr, char *pStr);

#endif /* DIRTREE_H */
