#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-gen-def:node-dict-expr2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L node-dict-expr2.old <(echo \
'$ set -o pipefail
$ json() { ../lib/test-gen --dict -T -d1 -k128 -e "$1"|LD_LIBRARY_PATH=../lib ../src/json -Td|sed -nr '\''/^\s*$/d;/^static\s+const\s+(uchar_t|struct\s+(bit_set_t(\s*\*)?|json_type_dict_attr_t))\s/,/^\}/p'\''; }
$ json '\''0'\''
static const uchar_t __386[16] = {};
static const struct bit_set_t __387 = {
    .size = 128,
    .u.ptr = __386
};
static const struct bit_set_t* __388[] = {
    &__387,
    NULL
};
static const struct json_type_dict_attr_t __389 = {
    .args = &__385,
    .expr = __388,
    .size = 1
};
$ json '\''1'\''
static const uchar_t __386[16] = {
    [0] = 0xffu,
    [1] = 0xffu,
    [2] = 0xffu,
    [3] = 0xffu,
    [4] = 0xffu,
    [5] = 0xffu,
    [6] = 0xffu,
    [7] = 0xffu,
    [8] = 0xffu,
    [9] = 0xffu,
    [10] = 0xffu,
    [11] = 0xffu,
    [12] = 0xffu,
    [13] = 0xffu,
    [14] = 0xffu,
    [15] = 0xffu,
};
static const struct bit_set_t __387 = {
    .size = 128,
    .u.ptr = __386
};
static const struct bit_set_t* __388[] = {
    &__387,
    NULL
};
static const struct json_type_dict_attr_t __389 = {
    .args = &__385,
    .expr = __388,
    .size = 1
};
$ json '\''`0`'\''
static const uchar_t __386[16] = {
    [0] = 0x01u,
};
static const struct bit_set_t __387 = {
    .size = 128,
    .u.ptr = __386
};
static const struct bit_set_t* __388[] = {
    &__387,
    NULL
};
static const struct json_type_dict_attr_t __389 = {
    .args = &__385,
    .expr = __388,
    .size = 1
};
$ json '\''`127`'\''
static const uchar_t __386[16] = {
    [15] = 0x80u,
};
static const struct bit_set_t __387 = {
    .size = 128,
    .u.ptr = __386
};
static const struct bit_set_t* __388[] = {
    &__387,
    NULL
};
static const struct json_type_dict_attr_t __389 = {
    .args = &__385,
    .expr = __388,
    .size = 1
};
$ json '\''`0`|`127`'\''
static const uchar_t __386[16] = {
    [0] = 0x01u,
    [15] = 0x80u,
};
static const struct bit_set_t __387 = {
    .size = 128,
    .u.ptr = __386
};
static const struct bit_set_t* __388[] = {
    &__387,
    NULL
};
static const struct json_type_dict_attr_t __389 = {
    .args = &__385,
    .expr = __388,
    .size = 1
};
$ json '\''`0`|`2`|`4`|`6`|`8`|`10`|`12`|`14`|`16`|`18`|`20`|`22`|`24`|`26`|`28`|`30`|`32`|`34`|`36`|`38`|`40`|`42`|`44`|`46`|`48`|`50`|`52`|`54`|`56`|`58`|`60`|`62`|`64`|`66`|`68`|`70`|`72`|`74`|`76`|`78`|`80`|`82`|`84`|`86`|`88`|`90`|`92`|`94`|`96`|`98`|`100`|`102`|`104`|`106`|`108`|`110`|`112`|`114`|`116`|`118`|`120`|`122`|`124`|`126`'\''
static const uchar_t __386[16] = {
    [0] = 0x55u,
    [1] = 0x55u,
    [2] = 0x55u,
    [3] = 0x55u,
    [4] = 0x55u,
    [5] = 0x55u,
    [6] = 0x55u,
    [7] = 0x55u,
    [8] = 0x55u,
    [9] = 0x55u,
    [10] = 0x55u,
    [11] = 0x55u,
    [12] = 0x55u,
    [13] = 0x55u,
    [14] = 0x55u,
    [15] = 0x55u,
};
static const struct bit_set_t __387 = {
    .size = 128,
    .u.ptr = __386
};
static const struct bit_set_t* __388[] = {
    &__387,
    NULL
};
static const struct json_type_dict_attr_t __389 = {
    .args = &__385,
    .expr = __388,
    .size = 1
};
$ json '\''`1`|`3`|`5`|`7`|`9`|`11`|`13`|`15`|`17`|`19`|`21`|`23`|`25`|`27`|`29`|`31`|`33`|`35`|`37`|`39`|`41`|`43`|`45`|`47`|`49`|`51`|`53`|`55`|`57`|`59`|`61`|`63`|`65`|`67`|`69`|`71`|`73`|`75`|`77`|`79`|`81`|`83`|`85`|`87`|`89`|`91`|`93`|`95`|`97`|`99`|`101`|`103`|`105`|`107`|`109`|`111`|`113`|`115`|`117`|`119`|`121`|`123`|`125`|`127`'\''
static const uchar_t __386[16] = {
    [0] = 0xaau,
    [1] = 0xaau,
    [2] = 0xaau,
    [3] = 0xaau,
    [4] = 0xaau,
    [5] = 0xaau,
    [6] = 0xaau,
    [7] = 0xaau,
    [8] = 0xaau,
    [9] = 0xaau,
    [10] = 0xaau,
    [11] = 0xaau,
    [12] = 0xaau,
    [13] = 0xaau,
    [14] = 0xaau,
    [15] = 0xaau,
};
static const struct bit_set_t __387 = {
    .size = 128,
    .u.ptr = __386
};
static const struct bit_set_t* __388[] = {
    &__387,
    NULL
};
static const struct json_type_dict_attr_t __389 = {
    .args = &__385,
    .expr = __388,
    .size = 1
};'
) -L node-dict-expr2.new <(
echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { ../lib/test-gen --dict -T -d1 -k128 -e "$1"|LD_LIBRARY_PATH=../lib ../src/json -Td|sed -nr '\''/^\s*$/d;/^static\s+const\s+(uchar_t|struct\s+(bit_set_t(\s*\*)?|json_type_dict_attr_t))\s/,/^\}/p'\''; }'
json() { ../lib/test-gen --dict -T -d1 -k128 -e "$1"|LD_LIBRARY_PATH=../lib ../src/json -Td|sed -nr '/^\s*$/d;/^static\s+const\s+(uchar_t|struct\s+(bit_set_t(\s*\*)?|json_type_dict_attr_t))\s/,/^\}/p'; } 2>&1 ||
echo 'command failed: json() { ../lib/test-gen --dict -T -d1 -k128 -e "$1"|LD_LIBRARY_PATH=../lib ../src/json -Td|sed -nr '\''/^\s*$/d;/^static\s+const\s+(uchar_t|struct\s+(bit_set_t(\s*\*)?|json_type_dict_attr_t))\s/,/^\}/p'\''; }'

echo '$ json '\''0'\'''
json '0' 2>&1 ||
echo 'command failed: json '\''0'\'''

echo '$ json '\''1'\'''
json '1' 2>&1 ||
echo 'command failed: json '\''1'\'''

echo '$ json '\''`0`'\'''
json '`0`' 2>&1 ||
echo 'command failed: json '\''`0`'\'''

echo '$ json '\''`127`'\'''
json '`127`' 2>&1 ||
echo 'command failed: json '\''`127`'\'''

echo '$ json '\''`0`|`127`'\'''
json '`0`|`127`' 2>&1 ||
echo 'command failed: json '\''`0`|`127`'\'''

echo '$ json '\''`0`|`2`|`4`|`6`|`8`|`10`|`12`|`14`|`16`|`18`|`20`|`22`|`24`|`26`|`28`|`30`|`32`|`34`|`36`|`38`|`40`|`42`|`44`|`46`|`48`|`50`|`52`|`54`|`56`|`58`|`60`|`62`|`64`|`66`|`68`|`70`|`72`|`74`|`76`|`78`|`80`|`82`|`84`|`86`|`88`|`90`|`92`|`94`|`96`|`98`|`100`|`102`|`104`|`106`|`108`|`110`|`112`|`114`|`116`|`118`|`120`|`122`|`124`|`126`'\'''
json '`0`|`2`|`4`|`6`|`8`|`10`|`12`|`14`|`16`|`18`|`20`|`22`|`24`|`26`|`28`|`30`|`32`|`34`|`36`|`38`|`40`|`42`|`44`|`46`|`48`|`50`|`52`|`54`|`56`|`58`|`60`|`62`|`64`|`66`|`68`|`70`|`72`|`74`|`76`|`78`|`80`|`82`|`84`|`86`|`88`|`90`|`92`|`94`|`96`|`98`|`100`|`102`|`104`|`106`|`108`|`110`|`112`|`114`|`116`|`118`|`120`|`122`|`124`|`126`' 2>&1 ||
echo 'command failed: json '\''`0`|`2`|`4`|`6`|`8`|`10`|`12`|`14`|`16`|`18`|`20`|`22`|`24`|`26`|`28`|`30`|`32`|`34`|`36`|`38`|`40`|`42`|`44`|`46`|`48`|`50`|`52`|`54`|`56`|`58`|`60`|`62`|`64`|`66`|`68`|`70`|`72`|`74`|`76`|`78`|`80`|`82`|`84`|`86`|`88`|`90`|`92`|`94`|`96`|`98`|`100`|`102`|`104`|`106`|`108`|`110`|`112`|`114`|`116`|`118`|`120`|`122`|`124`|`126`'\'''

echo '$ json '\''`1`|`3`|`5`|`7`|`9`|`11`|`13`|`15`|`17`|`19`|`21`|`23`|`25`|`27`|`29`|`31`|`33`|`35`|`37`|`39`|`41`|`43`|`45`|`47`|`49`|`51`|`53`|`55`|`57`|`59`|`61`|`63`|`65`|`67`|`69`|`71`|`73`|`75`|`77`|`79`|`81`|`83`|`85`|`87`|`89`|`91`|`93`|`95`|`97`|`99`|`101`|`103`|`105`|`107`|`109`|`111`|`113`|`115`|`117`|`119`|`121`|`123`|`125`|`127`'\'''
json '`1`|`3`|`5`|`7`|`9`|`11`|`13`|`15`|`17`|`19`|`21`|`23`|`25`|`27`|`29`|`31`|`33`|`35`|`37`|`39`|`41`|`43`|`45`|`47`|`49`|`51`|`53`|`55`|`57`|`59`|`61`|`63`|`65`|`67`|`69`|`71`|`73`|`75`|`77`|`79`|`81`|`83`|`85`|`87`|`89`|`91`|`93`|`95`|`97`|`99`|`101`|`103`|`105`|`107`|`109`|`111`|`113`|`115`|`117`|`119`|`121`|`123`|`125`|`127`' 2>&1 ||
echo 'command failed: json '\''`1`|`3`|`5`|`7`|`9`|`11`|`13`|`15`|`17`|`19`|`21`|`23`|`25`|`27`|`29`|`31`|`33`|`35`|`37`|`39`|`41`|`43`|`45`|`47`|`49`|`51`|`53`|`55`|`57`|`59`|`61`|`63`|`65`|`67`|`69`|`71`|`73`|`75`|`77`|`79`|`81`|`83`|`85`|`87`|`89`|`91`|`93`|`95`|`97`|`99`|`101`|`103`|`105`|`107`|`109`|`111`|`113`|`115`|`117`|`119`|`121`|`123`|`125`|`127`'\'''
)

