#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:dict8
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict8.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"zoo":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:2: {"zoo":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"zoo":false}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"foo":false,"zar":1}'\''
json: error: <stdin>:1:14: type check error: invalid argument name: expected "bar"
json: error: <stdin>:1:14: {"foo":false,"zar":1}
json: error: <stdin>:1:14:              ^
{"foo":false,
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"foo":false,"zar":1}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"bar":1,"zar":1}'\''
json: error: <stdin>:1:10: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:10: {"bar":1,"zar":1}
json: error: <stdin>:1:10:          ^
{"bar":1,
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"bar":1,"zar":1}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":1,"zaz":""}'\''
json: error: <stdin>:1:22: type check error: invalid argument name: expected "baz"
json: error: <stdin>:1:22: {"foo":false,"bar":1,"zaz":""}
json: error: <stdin>:1:22:                      ^
{"foo":false,"bar":1,
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":1,"zaz":""}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"bar":1,"foo":false,"zaz":""}'\''
json: error: <stdin>:1:22: type check error: invalid argument name: expected "baz"
json: error: <stdin>:1:22: {"bar":1,"foo":false,"zaz":""}
json: error: <stdin>:1:22:                      ^
{"bar":1,"foo":false,
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"bar":1,"foo":false,"zaz":""}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","zaa":{}}'\''
json: error: <stdin>:1:31: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:31: {"foo":false,"bar":1,"baz":"","zaa":{}}
json: error: <stdin>:1:31:                               ^
{"foo":false,"bar":1,"baz":"",
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","zaa":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"baz":"","foo":false,"bar":1,"zaa":{}}'\''
json: error: <stdin>:1:31: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:31: {"baz":"","foo":false,"bar":1,"zaa":{}}
json: error: <stdin>:1:31:                               ^
{"baz":"","foo":false,"bar":1,
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"baz":"","foo":false,"bar":1,"zaa":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"bar":1,"baz":"","foo":false,"zaa":{}}'\''
json: error: <stdin>:1:31: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:31: {"bar":1,"baz":"","foo":false,"zaa":{}}
json: error: <stdin>:1:31:                               ^
{"bar":1,"baz":"","foo":false,
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"bar":1,"baz":"","foo":false,"zaa":{}}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{},"zaa":[]}'\''
json: error: <stdin>:1:40: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:40: false,"bar":1,"baz":"","faa":{},"zaa":[]}
json: error: <stdin>:1:40:                                 ^
{"foo":false,"bar":1,"baz":"","faa":{},
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{},"zaa":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"faa":{},"foo":false,"bar":1,"baz":"","zaa":[]}'\''
json: error: <stdin>:1:40: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:40: {},"foo":false,"bar":1,"baz":"","zaa":[]}
json: error: <stdin>:1:40:                                 ^
{"faa":{},"foo":false,"bar":1,"baz":"",
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"faa":{},"foo":false,"bar":1,"baz":"","zaa":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"baz":"","faa":{},"foo":false,"bar":1,"zaa":[]}'\''
json: error: <stdin>:1:40: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:40: "","faa":{},"foo":false,"bar":1,"zaa":[]}
json: error: <stdin>:1:40:                                 ^
{"baz":"","faa":{},"foo":false,"bar":1,
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"baz":"","faa":{},"foo":false,"bar":1,"zaa":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"bar":1,"baz":"","faa":{},"foo":false,"zaa":[]}'\''
json: error: <stdin>:1:40: type check error: invalid argument name: expected "baa"
json: error: <stdin>:1:40: 1,"baz":"","faa":{},"foo":false,"zaa":[]}
json: error: <stdin>:1:40:                                 ^
{"bar":1,"baz":"","faa":{},"foo":false,
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"bar":1,"baz":"","faa":{},"foo":false,"zaa":[]}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{},"baa":[]}'\''
{"foo":false,"bar":1,"baz":"","faa":{},"baa":[]}'
) -L dict8.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"zoo":false}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"zoo":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"zoo":false}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"foo":false,"zar":1}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}' <<< '{"foo":false,"zar":1}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"foo":false,"zar":1}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"bar":1,"zar":1}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}' <<< '{"bar":1,"zar":1}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"}]}'\'' <<< '\''{"bar":1,"zar":1}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":1,"zaz":""}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}' <<< '{"foo":false,"bar":1,"zaz":""}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":1,"zaz":""}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"bar":1,"foo":false,"zaz":""}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}' <<< '{"bar":1,"foo":false,"zaz":""}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"}]}'\'' <<< '\''{"bar":1,"foo":false,"zaz":""}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","zaa":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}' <<< '{"foo":false,"bar":1,"baz":"","zaa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","zaa":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"baz":"","foo":false,"bar":1,"zaa":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}' <<< '{"baz":"","foo":false,"bar":1,"zaa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"baz":"","foo":false,"bar":1,"zaa":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"bar":1,"baz":"","foo":false,"zaa":{}}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}' <<< '{"bar":1,"baz":"","foo":false,"zaa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"}]}'\'' <<< '\''{"bar":1,"baz":"","foo":false,"zaa":{}}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{},"zaa":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}' <<< '{"foo":false,"bar":1,"baz":"","faa":{},"zaa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{},"zaa":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"faa":{},"foo":false,"bar":1,"baz":"","zaa":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}' <<< '{"faa":{},"foo":false,"bar":1,"baz":"","zaa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"faa":{},"foo":false,"bar":1,"baz":"","zaa":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"baz":"","faa":{},"foo":false,"bar":1,"zaa":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}' <<< '{"baz":"","faa":{},"foo":false,"bar":1,"zaa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"baz":"","faa":{},"foo":false,"bar":1,"zaa":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"bar":1,"baz":"","faa":{},"foo":false,"zaa":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}' <<< '{"bar":1,"baz":"","faa":{},"foo":false,"zaa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"bar":1,"baz":"","faa":{},"foo":false,"zaa":[]}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{},"baa":[]}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}' <<< '{"foo":false,"bar":1,"baz":"","faa":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"bar","type":"number"},{"name":"baz","type":"string"},{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":1,"baz":"","faa":{},"baa":[]}'\'''
)

