#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:list-empty-closed-array
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-empty-closed-array.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"list","args":[{"type":"array","args":[]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": []
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "val": {
                    "type": "array",
                    "args": []
                },
                "lo": null,
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":[]}]}'\''
json: error: <stdin>:1:51: attribute error: invalid "list" type object: duplicated '\''closed array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:51: gs":[{"type":"array","args":[]},{"type":"array","args":[]}]}
json: error: <stdin>:1:51:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":[]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":[]},{"type":"array","args":[]}]}'\''
json: error: <stdin>:1:51: attribute error: invalid "list" type object: duplicated '\''closed array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:51: gs":[{"type":"array","args":[]},{"type":"array","args":[]},{"type
json: error: <stdin>:1:51:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":[]},{"type":"array","args":[]}]}'\'''
) -L list-empty-closed-array.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":[]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":[]},{"type":"array","args":[]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":[]},{"type":"array","args":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":[]},{"type":"array","args":[]},{"type":"array","args":[]}]}'\'''
)

