#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:dict4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict4.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"bar":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"bar":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":true,"bar":null}
json: error: <stdin>:1:12:            ^
{"foo":true
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":123,"bar":null}
json: error: <stdin>:1:11:           ^
{"foo":123
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"foo","bar":null}
json: error: <stdin>:1:13:             ^
{"foo":"foo"
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"bar":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"bar":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"bar":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":false,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":true,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":123,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":"foo","bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":{},"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:8: {"foo":[],"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":null,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"bar":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":true,"bar":null}
json: error: <stdin>:1:12:            ^
{"foo":true
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":123,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":"foo","bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":{},"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:8: {"foo":[],"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":null,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":false,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":true,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":123,"bar":null}
json: error: <stdin>:1:11:           ^
{"foo":123
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":"foo","bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":{},"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:8: {"foo":[],"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":null,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":false,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":true,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":123,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"foo","bar":null}
json: error: <stdin>:1:13:             ^
{"foo":"foo"
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":{},"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:8: {"foo":[],"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":null,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":false,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":true,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":123,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":"foo","bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"bar":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:8: {"foo":[],"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":null,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":null,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":false,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":true,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":true,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":123,"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":123,"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":"foo","bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:8: {"foo":{},"bar":null}
json: error: <stdin>:1:8:        ^
{"foo":
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{},"bar":null}'\''
$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[],"bar":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"bar":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''
) -L dict4.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":null,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":false,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":true,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":123,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":"foo","bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":{},"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"type"}]}' <<< '{"foo":[],"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"type"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":null,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":false,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":true,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":123,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":"foo","bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":{},"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"null"}]}' <<< '{"foo":[],"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"null"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":null,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":false,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":true,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":123,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":"foo","bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":{},"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"boolean"}]}' <<< '{"foo":[],"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"boolean"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":null,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":false,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":true,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":123,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":"foo","bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":{},"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"number"}]}' <<< '{"foo":[],"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"number"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":null,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":false,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":true,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":123,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":"foo","bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":{},"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"string"}]}' <<< '{"foo":[],"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"string"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":null,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":false,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":true,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":123,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":"foo","bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":{},"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"object"}]}' <<< '{"foo":[],"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"object"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":null,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":null,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":false,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":false,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":true,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":true,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":123,"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":123,"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":"foo","bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":"foo","bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":{},"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":{},"bar":null}'\'''

echo '$ json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''
json -d '{"type":"dict","args":[{"name":"foo","type":"array"}]}' <<< '{"foo":[],"bar":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"dict","args":[{"name":"foo","type":"array"}]}'\'' <<< '\''{"foo":[],"bar":null}'\'''
)

