#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:dict-dup
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict-dup.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":null}},{"name":"foo","type":"type"}]}'\''
json: error: <stdin>:1:69: attribute error: invalid "dict" type object: duplicate key name (previous defined at 1:32)
json: error: <stdin>:1:69: ,"type":{"plain":null}},{"name":"foo","type":"type"}]}
json: error: <stdin>:1:69:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":null}},{"name":"foo","type":"type"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":false}},{"name":"foo","type":"type"}]}'\''
json: error: <stdin>:1:70: attribute error: invalid "dict" type object: duplicate key name (previous defined at 1:32)
json: error: <stdin>:1:70: "type":{"plain":false}},{"name":"foo","type":"type"}]}
json: error: <stdin>:1:70:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":false}},{"name":"foo","type":"type"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":true}},{"name":"foo","type":"type"}]}'\''
json: error: <stdin>:1:69: attribute error: invalid "dict" type object: duplicate key name (previous defined at 1:32)
json: error: <stdin>:1:69: ,"type":{"plain":true}},{"name":"foo","type":"type"}]}
json: error: <stdin>:1:69:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":true}},{"name":"foo","type":"type"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":123}},{"name":"foo","type":"type"}]}'\''
json: error: <stdin>:1:68: attribute error: invalid "dict" type object: duplicate key name (previous defined at 1:32)
json: error: <stdin>:1:68: ","type":{"plain":123}},{"name":"foo","type":"type"}]}
json: error: <stdin>:1:68:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":123}},{"name":"foo","type":"type"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":"foo"}},{"name":"foo","type":"type"}]}'\''
json: error: <stdin>:1:70: attribute error: invalid "dict" type object: duplicate key name (previous defined at 1:32)
json: error: <stdin>:1:70: "type":{"plain":"foo"}},{"name":"foo","type":"type"}]}
json: error: <stdin>:1:70:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":"foo"}},{"name":"foo","type":"type"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"foo","type":"type"}]}'\''
json: error: <stdin>:1:61: attribute error: invalid "dict" type object: duplicate key name (previous defined at 1:32)
json: error: <stdin>:1:61: e":"foo","type":"type"},{"name":"foo","type":"type"}]}
json: error: <stdin>:1:61:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"foo","type":"type"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"foo","type":"type"}]}'\''
json: error: <stdin>:1:61: attribute error: invalid "dict" type object: duplicate key name (previous defined at 1:32)
json: error: <stdin>:1:61: e":"foo","type":"null"},{"name":"foo","type":"type"}]}
json: error: <stdin>:1:61:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"foo","type":"type"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"foo","type":"type"}]}'\''
json: error: <stdin>:1:64: attribute error: invalid "dict" type object: duplicate key name (previous defined at 1:32)
json: error: <stdin>:1:64: "foo","type":"boolean"},{"name":"foo","type":"type"}]}
json: error: <stdin>:1:64:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"foo","type":"type"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"foo","type":"type"}]}'\''
json: error: <stdin>:1:63: attribute error: invalid "dict" type object: duplicate key name (previous defined at 1:32)
json: error: <stdin>:1:63: :"foo","type":"number"},{"name":"foo","type":"type"}]}
json: error: <stdin>:1:63:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"foo","type":"type"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"foo","type":"type"}]}'\''
json: error: <stdin>:1:63: attribute error: invalid "dict" type object: duplicate key name (previous defined at 1:32)
json: error: <stdin>:1:63: :"foo","type":"string"},{"name":"foo","type":"type"}]}
json: error: <stdin>:1:63:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"foo","type":"type"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"foo","type":"type"}]}'\''
json: error: <stdin>:1:63: attribute error: invalid "dict" type object: duplicate key name (previous defined at 1:32)
json: error: <stdin>:1:63: :"foo","type":"object"},{"name":"foo","type":"type"}]}
json: error: <stdin>:1:63:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"foo","type":"type"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"foo","type":"type"}]}'\''
json: error: <stdin>:1:62: attribute error: invalid "dict" type object: duplicate key name (previous defined at 1:32)
json: error: <stdin>:1:62: ":"foo","type":"array"},{"name":"foo","type":"type"}]}
json: error: <stdin>:1:62:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"foo","type":"type"}]}'\'''
) -L dict-dup.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":null}},{"name":"foo","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"foo","type":{"plain":null}},{"name":"foo","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":null}},{"name":"foo","type":"type"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":false}},{"name":"foo","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"foo","type":{"plain":false}},{"name":"foo","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":false}},{"name":"foo","type":"type"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":true}},{"name":"foo","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"foo","type":{"plain":true}},{"name":"foo","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":true}},{"name":"foo","type":"type"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":123}},{"name":"foo","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"foo","type":{"plain":123}},{"name":"foo","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":123}},{"name":"foo","type":"type"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":"foo"}},{"name":"foo","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"foo","type":{"plain":"foo"}},{"name":"foo","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":{"plain":"foo"}},{"name":"foo","type":"type"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"foo","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"foo","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"type"},{"name":"foo","type":"type"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"foo","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"foo","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"null"},{"name":"foo","type":"type"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"foo","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"foo","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"boolean"},{"name":"foo","type":"type"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"foo","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"foo","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"number"},{"name":"foo","type":"type"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"foo","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"foo","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"string"},{"name":"foo","type":"type"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"foo","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"foo","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"object"},{"name":"foo","type":"type"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"foo","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"foo","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"foo","type":"array"},{"name":"foo","type":"type"}]}'\'''
)

