#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-closed-array-plain-plain-val-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-plain-plain-val-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
) -L list-closed-array-plain-plain-val-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''[]'\'''
)

